﻿using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.Chat;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestGoftino: IHttpRequestGoftino
    {
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestGoftino(IRestRequestHelper restRequestHelper)
        {

            _restRequestHelper = restRequestHelper;

        }
        /// <summary>
        /// دریافت سوابق چت از سرویس گفتینو
        /// </summary>
        /// <param name="chat_id"></param>
        /// <param name="token"></param>
        /// <param name="server"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<GetChatGofitnoResponseModel> getGoftinoChat(string chat_id, string token
          , string server, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();

            headers.Add("goftino-key", token);

            var parameters = new Dictionary<string, object>();

            parameters.Add("chat_id", chat_id);

            var response = await _restRequestHelper.executeAsyncGet<GetChatGofitnoResponseModel>(server + "chat_data", parameters
                ,cancellationToken, headers);

            if (response != null)
            {
                return response.Data;
            }
            return null;

        }
    }
}
