﻿using RestSharp;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Captcha;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestImage: IHttpRequestImage
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly ITokenUserService _tokenUserService;
        private readonly RedisService _redis;
        private readonly ISettingContext _settingContext;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestImage(IRestRequestHelper restRequestHelper
            , ITokenUserService tokenUserService
            , ISettingContext settingContext, RedisService redis, IRedisContextService redisContextService)
        {

            _restRequestHelper = restRequestHelper;
            _tokenUserService = tokenUserService;
            _redis = redis;
            _redisContextService = redisContextService;
            _settingContext = settingContext;

        }
        public async Task<string> GetVolume(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.FileManager,cancellationToken);

            var response = await _restRequestHelper.executeAsyncGet<object>(setting.BaseUrlService + "datacenter/get-volume", new Dictionary<string, string> { }
                , cancellationToken, new Dictionary<string, string> { { "Authorization", "Bearer "+_tokenUserService.getJWTToken() } });
            if (response.IsSuccessful)
            {
                if(response.Data == null || Convert.ToInt64(response.Content) <= 0)
                {
                    return "error-" + "هشدار اختلال در سیستم: حجم باقی مانده از فایل منیجر صفر و یا غیر قابل محاسبه است ، لذا احتمال اختلال در کارکرد سیستم وجود دارد";
                }
                return "success-" + $"حجم باقی مانده از فضای فایل منیجر: {response.Data}";
            }
            return "error-"+"هشدار اختلال در سیستم: ارتباط با سرویس های فایل منیجر برقرار نمی باشد";
        }
        public async Task<string> CheckConnection(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.FileManager, cancellationToken);

            var response = await _restRequestHelper.executeAsyncGet<bool>(setting.BaseUrlService + "datacenter/check", new Dictionary<string, string> { }
                ,  cancellationToken, new Dictionary<string, string> { { "Authorization", "Bearer " + _tokenUserService.getJWTToken() } });
            if (response.IsSuccessful && response.Data)
            {
                return "success-" + "فایل منیجر پایدار و متصل است";
            }
            return "error-" + "هشدار اختلال در سیستم: ارتباط با هاست فایل منیجر برقرار نمی باشد";
        }
    }
}
