﻿using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.JibitInquiry;
using Farakonesh.Models.API.JibitOcr;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Shared.Enums;
using RestSharp;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestJibit: IHttpRequestJibit
    {
        private readonly IRedisContextService _redisContextService;
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestJibit(IRedisContextService redisContextService, IRestRequestHelper restRequestHelper)
        {
            _restRequestHelper = restRequestHelper;
            _redisContextService = redisContextService;
        }
        public async Task<string> checkConnection(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGShepa, cancellationToken);

            var ping = new System.Net.NetworkInformation.Ping();
            var url = webServiceInfo.BaseUrlService.Replace("https://", "");
            var result = ping.Send(url.Split("/")[0]);

            if (result.Status != System.Net.NetworkInformation.IPStatus.Success)
                return "error-" + "اخطار: ارتباط با سرویس استعلام جیبیت برقرار نشد ، باید مطمئن شوید که مشکلی وجود نداشته باشد";
            else
                return "success-" + "سرویس استعلام جیبیت متصل است";
        }
        /// <summary>
        /// دریافت امضای جیبیت
        /// </summary>
        /// <param name="apiKey"></param>
        /// <param name="secretKey"></param>
        /// <param name="server"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<ResponseTokenJibit> getTokenJibit(string apiKey, string secretKey, string server, CancellationToken cancellationToken)
        {

            var response = await _restRequestHelper.executeAsync<ResponseTokenJibit>(server + "tokens/generate", new { apiKey, secretKey }, Method.Post
                , cancellationToken);

            if (response != null)
            {
                return response.Data;

            }
            return null;
        }
        /// <summary>
        /// بررسی تطابق کارت بانکی با کد ملی
        /// </summary>
        /// <param name="model"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<ResponseMatchJibit> checkCardBankJibit(RequestMatchCardBankJibit model, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + model.Token);

            var parameters = new Dictionary<string, string>();
            parameters.Add("cardNumber", model.CardBank);
            parameters.Add("nationalCode", model.NationalCode);
            parameters.Add("birthDate", model.BirthDate);

            var response = await _restRequestHelper.executeAsyncGet<ResponseMatchJibit>(model.Server + "services/matching", parameters
                , cancellationToken, headers);
            if (response != null)
            {
                return response.Data;

            }
            return null;
        }
        /// <summary>
        /// تبدیل شماره کارت به شماره شبا و حساب
        /// </summary>
        /// <param name="cardBank"></param>
        /// <param name="token"></param>
        /// <param name="server"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<ResponseConvertToShebaJibit> getCardBankDetailsJibit(string cardBank, string token, string server, CancellationToken cancellationToken)
        {

            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + token);

            var parameters = new Dictionary<string, object>();
            parameters.Add("number", cardBank);
            parameters.Add("iban", true);

            var response = await _restRequestHelper.executeAsyncGet<ResponseConvertToShebaJibit>(server + "cards", parameters
                ,cancellationToken, headers);
            if (response != null)
            {
                return response.Data;

            }
            return null;
        }

     
        /// <summary>
        /// بررسی صحبت اطلاعات هویتی کاربر ، باتوجه به اطلاعات درج شده در ثبت احوال
        /// </summary>
        /// <param name="model"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<ResponseRegisteryOfficeJibit> getIdentityRegisteryOffice(RequestRegisteyOfficeJibit model, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + model.Token);

            var parameters = new Dictionary<string, object>();
            parameters.Add("nationalCode", model.NationalCode);
            parameters.Add("birthDate", model.BirthDate);
            parameters.Add("lastName", model.LastName);
            parameters.Add("firstName", model.FirstName);
            parameters.Add("fullName", model.FirstName + " " + model.LastName);

            var response = await _restRequestHelper.executeAsyncGet<ResponseRegisteryOfficeJibit>(model.Server + "services/identity/similarity", parameters
                , cancellationToken, headers);

            if (response != null)
            {
                return response.Data;
            }
            return null;
        }
        /// <summary>
        /// بررسی تطابق شماره همراه با کدملی
        /// </summary>
        /// <param name="model"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<ResponseMatchJibit> CheckShahkar(RequestMatchShahkarJibit model, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + model.Token);

            var parameters = new Dictionary<string, string>();
            parameters.Add("nationalCode", model.NationalCode);
            parameters.Add("mobileNumber", model.MobileNumber);

            var response = await _restRequestHelper.executeAsyncGet<ResponseMatchJibit>(model.Server + "services/matching", parameters
                , cancellationToken, headers);
            if (response != null)
            {
                return response.Data;

            }
            return null;
        }

        public async Task<ResponsePostalJibit> GetAddressPostalCode(RequestPostalJibit model, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + model.Token);

            var parameters = new Dictionary<string, string>();
            parameters.Add("code", model.PostalCode);

            var response = await _restRequestHelper.executeAsyncGet<ResponsePostalJibit>(model.Server + "services/postal", parameters
                , cancellationToken, headers);
            if (response != null)
            {
                return response.Data;

            }
            return null;
        }

        public async Task<ResponseJibitOcr> getNationalCardOcrJibit(RequestJibitOcr model, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + model.Token);

            var response = await _restRequestHelper.executeAsyncMultiPart<ResponseJibitOcr>(model.BaseUrl, "ocr", model.FileUrl, Method.Post
                ,cancellationToken, headers);

            if (response != null)
            {
                return response.Data;
            }
            return null;
        }

    }
}
