﻿using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.JibitOnlinePay;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Helpers;
using RestSharp;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Diagnostics.Eventing.Reader;
using System.Net;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestJibitPPG : IHttpRequestJibitPPG
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestJibitPPG(IRestRequestHelper restRequestHelper, IRedisContextService redisContextService)
        {
            _restRequestHelper = restRequestHelper;
            _redisContextService = redisContextService;
        }

        public async Task<string> checkConnectionPPG(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGShepa, cancellationToken);

            var ping = new System.Net.NetworkInformation.Ping();
            var url = webServiceInfo.BaseUrlService.Replace("https://", "");
            var result = ping.Send(url.Split("/")[0]);

            if (result.Status != System.Net.NetworkInformation.IPStatus.Success)
                return "error-" + "اخطار: ارتباط با درگاه پرداخت جیبیت برقرار نشد ، باید مطمئن شوید که مشکلی وجود نداشته باشد";
            else
                return "success-" + "سرویس درگاه پرداخت جیبیت متصل است ، اما به معنای فعال بودن قطعی درگاه پرداخت نیست ، جهت اطمینان روی دکمه ی بررسی درگاه کلیک کنید";


        }
        public async Task<ResponseTokenJibitPPG> getTokenJibitPPG(string apiKey, string secretKey, string server, CancellationToken cancellationToken)
        {

            var response = await _restRequestHelper.executeAsync<ResponseTokenJibitPPG>(server + "tokens", new { apiKey, secretKey }, Method.Post
                , cancellationToken);

            if (response != null)
            {
                return response.Data;

            }
            return null;
        }
        /// <summary>
        /// ارسال درخواست پرداخت به سمت درگاه
        /// </summary>
        /// <param name="model"></param>
        /// <param name="accessToken"></param>
        /// <param name="server"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<ResponsePurchasesJibitPPG> purchaseJibitPPG(RequestPurchasesJibitPPG model, string accessToken
            , string server, CancellationToken cancellationToken)
        {

            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);
            var response = await _restRequestHelper.executeAsync<ResponsePurchasesJibitPPG>(server + "purchases", model, Method.Post
                , cancellationToken, headers);

            if (response != null)
            {
                return response.Data;

            }
            return null;
        }

        public async Task<ResponseJibitLinkOnlinePayPPG> purchaseJibitPPGLink(RequestJibitLinkOnlinePayPPG model
            , string accessToken, string server, CancellationToken cancellationToken)
        {

            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);
            var response = await _restRequestHelper.executeAsync<ResponseJibitLinkOnlinePayPPG>(server + "purchases/link", model, Method.Post
                , cancellationToken, headers);

            if (response != null)
            {
                return response.Data;
            }
            return null;
        }
        /// <summary>
        /// دریافت لیست سوابق پرداخت از جیبیت
        /// </summary>
        /// <param name="model"></param>
        /// <param name="accessToken"></param>
        /// <param name="server"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<ResponsePurchaseFilterJibitPPG> getPurchaseJibitPPG(RequestPurchaseFilterJibitPPG model
            , string accessToken, string server, CancellationToken cancellationToken)
        {

            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);

            var parameters = new Dictionary<string, object>();

            if (!string.IsNullOrWhiteSpace(model.purchaseId))
                parameters.Add("purchaseId", model.purchaseId);

            if (model.from != null)
                parameters.Add("from", model.from.resetFormatDateTimeToFourteenCharacter());

            if (model.to != null)
                parameters.Add("to", model.to.resetFormatDateTimeToFourteenCharacter());

            if (model.size != null && model.size>0)
                parameters.Add("size", model.size);

            if (model.page != null && model.page>0)
                parameters.Add("page", model.page);

            if (!string.IsNullOrWhiteSpace(model.status))
                parameters.Add("status", model.status);

            var response = await _restRequestHelper.executeAsyncGet<ResponsePurchaseFilterJibitPPG>(server + "purchases", parameters
                , cancellationToken, headers);

            if (response != null && !string.IsNullOrWhiteSpace(response.Content))
            {
                return response.Content.JsonToT<ResponsePurchaseFilterJibitPPG>();

            }
            return null;


        }

        public async Task<ResponseVerifyJibitPPG> verifyJibitPPG(string purchaseId, string accessToken, string server, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);
            var response = await _restRequestHelper.executeAsync<ResponseVerifyJibitPPG>(server + "purchases/" + purchaseId + "/verify", new { }, Method.Post
                , cancellationToken, headers);

            if (response != null)
            {
                return response.Data;

            }
            return null;
        }
    }
}
