﻿using RestSharp;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Captcha;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.Kavenegar;
using Newtonsoft.Json.Linq;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestKavenegar: IHttpRequestKavenegar
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestKavenegar(IRestRequestHelper restRequestHelper,
            IRedisContextService redisContextService)
        {

            _redisContextService = redisContextService;
            _restRequestHelper = restRequestHelper;

        }
        /// <summary>
        /// دریافت اطلاعات و وضعیت حساب سرویس پیامکی کاوه نگار
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<AccountInfoKavenegarResponseModel> accountInfo(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.Kavenegar,cancellationToken);
     
            var headers = new Dictionary<string, string>();
            var parameters = new Dictionary<string, object>();
            var response = await _restRequestHelper.executeAsyncGet<AccountInfoKavenegarResponseModel>(setting.BaseUrlService + setting.RealApiKey + "/account/info.json",parameters
                , cancellationToken,headers);
            return response.Data;
        }
    }
}
