﻿using Azure.Core;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.Kavenegar;
using Farakonesh.Models.API.Mediana;
using RestSharp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public class HttpRequestMediana: IHttpRequestMediana
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestMediana(IRestRequestHelper restRequestHelper,
            IRedisContextService redisContextService)
        {

            _redisContextService = redisContextService;
            _restRequestHelper = restRequestHelper;

        }

        public async Task<ResponseMedianaSendSms> SendSms(RequestMedianaSendSms command, CancellationToken cancellationToken)
        {

            var headers = new Dictionary<string, string>();
            headers.Add("X-API-Key", command.ApiKey);
            command.Text = command.SystemTitle + Environment.NewLine + command.Text + Environment.NewLine + "لغو11";
            var bodyRequest = new List<object>();
            bodyRequest.Add(new
            {
                DestinationAddress = command.Mobile,
                MessageText = command.Text,
                SourceAddress = command.Sender
            });
            var response = await _restRequestHelper.executeAsync<ResponseMedianaSendSms>(command.BaseUrl+"api/message/send",
                bodyRequest ,Method.Post, cancellationToken, headers);
            return response.Data;
        }
    }
}
