﻿using RestSharp;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.ArvanCloud;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.Nipoto.Response;
using Farakonesh.Models.API.Nipoto.Request;
using Farakonesh.Shared.Enums;
using Farakonesh.Models.API.Nipoto.Creating.Response;
using Farakonesh.Models.API.Nipoto.Creating.Request;
using Farakonesh.Shared.Helpers;
using Farakonesh.Models.API.Nipoto.Deal.Response;
using Newtonsoft.Json;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Models.Database.Systems;
using Farakonesh.Logic.IServices.ICache;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestNipoto : IHttpRequestNipoto
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestNipoto(IRestRequestHelper restRequestHelper, IRedisContextService redisContextService)
        {
            _restRequestHelper = restRequestHelper;
            _redisContextService = redisContextService;
        }

        public async Task<DBResult<LoginResponseNipotoModel>> GetToken(NipotoTokenType type, CancellationToken cancellationToken)
        {
            var webServiceInfo = new ResponseCache();
            var model = new LoginRequestNipotoModel();
            switch (type)
            {
                case NipotoTokenType.Deal:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoDeal
                        ,cancellationToken);
                    model.apiKey = webServiceInfo.RealApiKey;
                    model.secretKey = webServiceInfo.RealPassword;
                    break;
                case NipotoTokenType.Withdraw:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoPickUp
                        , cancellationToken);
                    model.apiKey = webServiceInfo.RealApiKey;
                    model.secretKey = webServiceInfo.RealPassword;
                    break;
                case NipotoTokenType.Creating:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoCreateAddress
                        , cancellationToken);
                    model.apiKey = webServiceInfo.RealApiKey;
                    model.secretKey = webServiceInfo.RealPassword;
                    break;
                default:
                    break;
            }
            var response = await _restRequestHelper.executeAsync<LoginResponseNipotoModel>(webServiceInfo.BaseUrlService+ $"v1/user/login", model
                , Method.Post, cancellationToken);

            if (response != null && response.Data != null && (response.StatusCode == System.Net.HttpStatusCode.OK))
            {
                return new DBResult<LoginResponseNipotoModel>(response.Data);
            }
            if (response != null && response.Data != null && !string.IsNullOrWhiteSpace(response.Data.code) && string.IsNullOrWhiteSpace(getErrorMessage(response.Data.code)))
            {
                return new DBResult<LoginResponseNipotoModel>(response.Data);
            }
            throw new ExternalServiceException("خطا در ایجاد امضای کاربری رمز ارز");
        }

        public async Task<DBResult<CreateWalletResponseModel>> CreateWallet(NipotoTokenType type, string accessToken, CreateWalletRequestModel model, CancellationToken cancellationToken)
        {
            var webServiceInfo = new ResponseCache();
            switch (type)
            {
                case NipotoTokenType.Deal:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoDeal
                        , cancellationToken);
                    break;
                case NipotoTokenType.Withdraw:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoPickUp
                        , cancellationToken);
                    break;
                case NipotoTokenType.Creating:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoCreateAddress
                        , cancellationToken);
                    break;
                default:
                    break;
            }
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);
            var response = await _restRequestHelper.executeAsync<CreateWalletResponseModel>(webServiceInfo.BaseUrlService + $"v1/accounting/wallet", model
                , Method.Post, cancellationToken, headers);

            if (response != null && response.Data != null && (response.StatusCode == System.Net.HttpStatusCode.OK))
            {
                return new DBResult<CreateWalletResponseModel>(response.Data);
            }
            if (response != null && response.Data != null && !string.IsNullOrWhiteSpace(response.Data.code) && string.IsNullOrWhiteSpace(getErrorMessage(response.Data.code)))
            {
                return new DBResult<CreateWalletResponseModel>(response.Data);
            }
            throw new ExternalServiceException("خطا در ایجاد کیف پول رمز ارز");
        }

        public async Task<DBResult<InfoDepositResponseModel>> GetDepositById(NipotoTokenType type, string accessToken, string depositId, CancellationToken cancellationToken)
        {
            var webServiceInfo = new ResponseCache();
            switch (type)
            {
                case NipotoTokenType.Deal:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoDeal
                        , cancellationToken);
                    break;
                case NipotoTokenType.Withdraw:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoPickUp
                        , cancellationToken);
                    break;
                case NipotoTokenType.Creating:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoCreateAddress
                        , cancellationToken);
                    break;
                default:
                    break;
            }
            var parameters = new Dictionary<string, string>();
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);
            var response = await _restRequestHelper.executeAsyncGet<InfoDepositResponseModel>(webServiceInfo.BaseUrlService + $"v1/accounting/deposit/{depositId}"
                , parameters, cancellationToken, headers);

            if (response != null && response.Data != null && (response.StatusCode == System.Net.HttpStatusCode.OK))
            {
                return new DBResult<InfoDepositResponseModel>(response.Data);
            }
            if (response != null && response.Data != null && !string.IsNullOrWhiteSpace(response.Data.code) && string.IsNullOrWhiteSpace(getErrorMessage(response.Data.code)))
            {
                return new DBResult<InfoDepositResponseModel>(response.Data);
            }

            throw new ExternalServiceException("خطا در استعلام شناسه واریزی");
        }

        public async Task<DBResult<List<InfoDepositResponseModel>>> GetDepositList(NipotoTokenType type, string accessToken, InfoDepositRequestModel model, CancellationToken cancellationToken)
        {
            var webServiceInfo = new ResponseCache();
            switch (type)
            {
                case NipotoTokenType.Deal:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoDeal
                        , cancellationToken);
                    break;
                case NipotoTokenType.Withdraw:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoPickUp
                        , cancellationToken);
                    break;
                case NipotoTokenType.Creating:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoCreateAddress
                        , cancellationToken);
                    break;
                default:
                    break;
            }
            var parameters = new Dictionary<string, string>();
            if (!string.IsNullOrWhiteSpace(model.origin))
            {
                parameters.Add("origin", model.origin);
            }
            if (model.pageNumber != null && model.pageNumber > 0)
            {
                parameters.Add("pageNumber", model.pageNumber.ToString());
            }
            if (model.pageCount != null && model.pageCount > 0)
            {
                parameters.Add("pageCount", model.pageCount.ToString());
            }
            if (!string.IsNullOrWhiteSpace(model.status))
            {
                parameters.Add("status", model.status);
            }
            if (!string.IsNullOrWhiteSpace(model.wallet))
            {
                parameters.Add("wallet", model.wallet);
            }
            if (!string.IsNullOrWhiteSpace(model.currency))
            {
                parameters.Add("currency", model.currency);
            }
            if (!string.IsNullOrWhiteSpace(model.network))
            {
                parameters.Add("network", model.network);
            }
            if (model.startDate != null)
            {
                parameters.Add("startDate", model.startDate.resetFormatDateTimeToFourteenCharacter());
            }

            if (model.endDate != null)
            {
                parameters.Add("endDate", model.endDate.resetFormatDateTimeToFourteenCharacter());
            }

            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);

            var response = await _restRequestHelper.executeAsyncGet<List<InfoDepositResponseModel>>(webServiceInfo.BaseUrlService + $"v1/accounting/deposit"
                , parameters, cancellationToken, headers);

            if (response != null && response.Data != null && (response.StatusCode == System.Net.HttpStatusCode.OK))
            {
                return new DBResult<List<InfoDepositResponseModel>>(response.Data);
            }
            if (response != null && response.Data != null && response.Data.Count > 0 && !string.IsNullOrWhiteSpace(response.Data[0].code) && string.IsNullOrWhiteSpace(getErrorMessage(response.Data[0].code)))
            {
                return new DBResult<List<InfoDepositResponseModel>>(response.Data);
            }

            throw new ExternalServiceException("خطا در استعلام شناسه واریزی");
        }
        /// <summary>
        /// دریافت اطلاعات موجودی از حساب نیپوتو
        /// </summary>
        /// <param name="baseUrl"></param>
        /// <param name="accessToken"></param>
        /// <param name="model"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="ExternalServiceException"></exception>
        public async Task<DBResult<BalanceResponseNipotoModel>> GetBalance(NipotoTokenType type, string accessToken, BalanceRequestNipotoModel model, CancellationToken cancellationToken)
        {
            var webServiceInfo = new ResponseCache();
            switch (type)
            {
                case NipotoTokenType.Deal:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoDeal
                        , cancellationToken);
                    break;
                case NipotoTokenType.Withdraw:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoPickUp
                        , cancellationToken);
                    break;
                case NipotoTokenType.Creating:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoCreateAddress
                        , cancellationToken);
                    break;
                default:
                    break;
            }
            var parameters = new Dictionary<string, string>();
            if (!string.IsNullOrWhiteSpace(model.currency))
            {
                parameters.Add("currency", model.currency);
            }

            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);

            var response = await _restRequestHelper.executeAsyncGet<BalanceResponseNipotoModel>(webServiceInfo.BaseUrlService + $"v1/accounting/balance"
                , parameters, cancellationToken, headers);

            if (response != null && response.Data != null && (response.StatusCode == System.Net.HttpStatusCode.OK))
            {
                return new DBResult<BalanceResponseNipotoModel>(response.Data);
            }
            if (response != null && response.Data != null && !string.IsNullOrWhiteSpace(response.Data.code) && string.IsNullOrWhiteSpace(getErrorMessage(response.Data.code)))
            {
                return new DBResult<BalanceResponseNipotoModel>(response.Data);
            }

            throw new ExternalServiceException("خطا در دریافت اطلاعات موجودی");
        }

        public async Task<DBResult<FeeNipotoResponseModel>> GetFee(NipotoTokenType type, string accessToken, CancellationToken cancellationToken)
        {
            var webServiceInfo = new ResponseCache();
            switch (type)
            {
                case NipotoTokenType.Deal:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoDeal
                        , cancellationToken);
                    break;
                case NipotoTokenType.Withdraw:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoPickUp
                        , cancellationToken);
                    break;
                case NipotoTokenType.Creating:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoCreateAddress
                        , cancellationToken);
                    break;
                default:
                    break;
            }
            var parameters = new Dictionary<string, string>();
            
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);

            var response = await _restRequestHelper.executeAsyncGet<FeeNipotoResponseModel>(webServiceInfo.BaseUrlService + $"v1/accounting/withdraw/fee"
                , parameters, cancellationToken, headers);

            if (response != null && response.Data != null && (response.StatusCode == System.Net.HttpStatusCode.OK))
            {
                return new DBResult<FeeNipotoResponseModel>(response.Data);
            }
            if (response != null && response.Data != null && !string.IsNullOrWhiteSpace(response.Data.code) && string.IsNullOrWhiteSpace(getErrorMessage(response.Data.code)))
            {
                return new DBResult<FeeNipotoResponseModel>(response.Data);
            }

            throw new ExternalServiceException("خطا در دریافت اطلاعات کارمزد ها");
        }
        /// <summary>
        /// دریافت لیست آپدیت قیمت ها از مارکت نیپوتو
        /// </summary>
        /// <param name="baseUrl"></param>
        /// <param name="accessToken"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="ExternalServiceException"></exception>
        public async Task<DBResult<MarketNipotoResponseModel>> GetMarket(NipotoTokenType type, string accessToken,CancellationToken cancellationToken)
        {
            var webServiceInfo = new ResponseCache();
            switch (type)
            {
                case NipotoTokenType.Deal:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoDeal
                        , cancellationToken);
                    break;
                case NipotoTokenType.Withdraw:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoPickUp
                        , cancellationToken);
                    break;
                case NipotoTokenType.Creating:
                    webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.NipotoCreateAddress
                        , cancellationToken);
                    break;
                default:
                    break;
            }
            var parameters = new Dictionary<string, string>();

            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + accessToken);

            var response = await _restRequestHelper.executeAsyncGet<List<List<object>>>(webServiceInfo.BaseUrlService + $"v1/market/list"
                , parameters, cancellationToken, headers);
            var responseList = new MarketNipotoResponseModel();
            if (response != null && (response.StatusCode == System.Net.HttpStatusCode.OK))
            {

                var responseModel = JsonConvert.DeserializeObject<List<List<object>>>(response.Content);
                foreach (var item in responseModel)
                {
                    string marketCode = "";
                    decimal? price = 0;
                    decimal? bestBid = 0;
                    decimal? bestAsk = 0;
                    var index = 0;
                    foreach (var subItem in item)
                    {
                        switch (index)
                        {
                            case 0:
                                marketCode = subItem != null ? subItem.ToString() : "";
                                break;
                            case 1:
                                price = subItem!=null? Convert.ToDecimal(subItem):0;
                                break;
                            case 2:
                                bestBid = subItem != null ? Convert.ToDecimal(subItem) : 0;
                                break;
                            case 3:
                                bestAsk = subItem != null ? Convert.ToDecimal(subItem) : 0;
                                break;
                            default:
                                break;
                        }

                        index++;
                    }
                    responseList.Response.Add(new MarketNipotoResponseModelItem
                    {
                        bestAsk = bestAsk,
                        bestBid = bestBid,
                        marketCode = marketCode,
                        price = price
                    });
                }

                return new DBResult<MarketNipotoResponseModel>(responseList);
            }
            else if(response != null && response.StatusCode != System.Net.HttpStatusCode.OK)
            {
                var responseError = response.Content.JsonToT<BaseResponseNipotoModel>();
                responseList.error = responseError.error;
                responseList.message = responseError.message;
                responseList.statusCode = responseError.statusCode;
                responseList.code = responseError.code;
                if (response != null && !string.IsNullOrWhiteSpace(responseList.code) && string.IsNullOrWhiteSpace(getErrorMessage(responseList.code)))
                {
                    return new DBResult<MarketNipotoResponseModel>(responseList);
                }

            }
           

            throw new ExternalServiceException("خطا در دریافت لیست قیمت ها");
        }

        private string getErrorMessage(string code)
        {
            switch (code)
            {
                case "SOMETHING_WENT_WRONG":
                    throw new ExternalServiceException("خطا در انجام عملیات در سرویس های نیپوتو رخ داده است ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                case "FORBIDDEN":
                    throw new ExternalServiceException("خطای دسترسی در سرویس های نیپوتو رخ داده است ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                case "ACCESS_TOKEN_IS_REQUIRED":
                    return "";
                case "INVALID_TOKEN":
                    return "";
                case "TOKEN_IS_EXPIRED":
                    return "";
                case "INVALID_IP":
                    throw new ExternalServiceException("خطای دسترسی آی پی در سرویس های نیپوتو رخ داده است ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                case "INVALID_ADDRESS":
                    throw new ExternalServiceException("آدرس ارسالی اشتباه است");
                case "INVALID_CURRENCY":
                    throw new ExternalServiceException("رمز ارز درخواستی اشتباه است");
                case "INVALID_NETWORK":
                    throw new ExternalServiceException("شبکه ی رمز ارز درخواستی اشتباه است");
                case "ERROR_IN_GENERATING_WALLET":
                    throw new ExternalServiceException("خطایی در ایجاد کیف پول رمز ارز بوجود آمده است ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                case "YOUR_TOKEN_DOESNT_SUPPORT_THIS_NETWORK":
                    throw new ExternalServiceException("خطای امنیتی در استفاده از سرویس رخ داده است ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                case "NETWORK_IS_DISABLE":
                    throw new ExternalServiceException("شبکه ی رمز ارز غیر فعال است ، لطفا شبکه ی دیگری را انتخاب نمایید");
                case "TOO_MANY_WALLET_GENERATED":
                    throw new ExternalServiceException("ایجاد کیف پول رمز ارزی به حد نصاب رسیده است ، لطفا دقایقی دیگر مجددا تلاش فرمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                case "ERROR_IN_SENDING_REQUEST":
                    throw new ExternalServiceException("خطا در ارسال درخواست به نیپوتو بوجود آمده است ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                case "NOT_ENOUGH_BALANCE":
                    throw new ExternalServiceException("موجودی کافی جهت برداشت وجود ندارد");
                case "INVALID_DEPOSIT_ID":
                    throw new ExternalServiceException("شناسه واریز یافت نشد");
                default:
                    throw new ExternalServiceException("خطایی در سرویس نیپوتو رخ داده است");
            }
        }
    }
}
