﻿using RestSharp;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.Captcha;
using Farakonesh.Models.API.OAuth;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestOAuth: IHttpRequestOAuth
    {
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestOAuth(IRestRequestHelper restRequestHelper)
        {

            _restRequestHelper = restRequestHelper;

        }
        public async Task<object> verifyGoogleToken(string token, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<object>(server + "OAuth/verifyToken", new { tokenId = token }, Method.Post
                , cancellationToken);
            if (response.IsSuccessful)
            {
                return response.Data;
            }

            throw new ExternalServiceException("خطا در دریافت نتیجه ی ورود به سیستم");
        }
        public async Task<TokenInfoGoogleResponseModel> getTokenInfo(string token, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<TokenInfoGoogleResponseModel>(server + "OAuth/getTokenInfo", new { tokenId = token }, Method.Post
                , cancellationToken);
            if (response.IsSuccessful)
            {
                return response.Data;
            }

            throw new ExternalServiceException("خطا در دریافت نتیجه ی ورود به سیستم");
        }
    }
}
