﻿using RestSharp;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Security.Principal;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestPayeer: IHttpRequestPayeer
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestPayeer(IRestRequestHelper restRequestHelper, IRedisContextService redisContextService)
        {
            _restRequestHelper = restRequestHelper;
            _redisContextService = redisContextService;
        }
        /// <summary>
        /// استعلام موجودی حساب پایر
        /// </summary>
        /// <param name="model"></param>
        /// <param name="server"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="ExternalException"></exception>
        public async Task<ResponseBalancePayeerModel> getAccountBalancePayeer(RequestBalancePayeerModel model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponseBalancePayeerModel>(server + "Payeer/balance", model, Method.Post
                , cancellationToken);
            if (response != null && response.Data != null)
            {
                return response.Data;
            }
            throw new ExternalException($"خطا در استعلام از پایر");
        }
        public async Task<string> getAccountBalancePayeerAlarm(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer,cancellationToken);
            
            var model = new RequestBalancePayeerModel();
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            model.account = webServiceInfo.Username;
            model.apiPass = (string)config["apiKeyBuy"];
            model.apiId = (string)config["shopNumberBuy"];
            var response = await _restRequestHelper.executeAsync<ResponseBalancePayeerModel>(webServiceInfo.BaseUrlService + "Payeer/balance", model, Method.Post
                , cancellationToken);
            if (response != null && response.Data != null && response.Data.auth_error == "0")
            {
                if (response.Data.balance.USD.available < 10)
                {
                   return "error-" + "اخطار: میزان شارژ دلاری پایر کمتر از 10 می باشد";
                }
                return "success-"+"وضعیت سرویس پایر پایدار است";
            }
            return "error-"+"اخطار: ارتباط با سرویس پایر برقرار نشد ، لطفا بررسی کنید تا مشکلی بوجود نیاید";
        }
        /// <summary>
        /// دریافت سابقه خرید و فروش پایر
        /// </summary>
        /// <param name="model"></param>
        /// <param name="server"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="ExternalException"></exception>
        public async Task<ResponseHistoryPayeerModel> getHistoryPayeer(RequestHistoryPayeerModel model
          , string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponseHistoryPayeerModel>(server + "Payeer/history", model, Method.Post
                , cancellationToken);
            if (response != null && response.Data != null)
            {
                var responseObject = response.Content.JsonToT<ResponseHistoryPayeerModel>();
                return responseObject;
            }
            throw new ExternalException($"خطا در استعلام از پایر");
        }

        public async Task<ResponseAuthPayeerModel> checkAuthBPayeer(RequestAuthPayeerModel model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponseAuthPayeerModel>(server + "Payeer/auth", model, Method.Post
                , cancellationToken);
            if (response != null && response.Data != null)
            {
                return response.Data;
            }
            throw new ExternalException($"خطا در استعلام از پایر");
        }

        public async Task<ResponseCheckUserPayeerModel> checkAccountPayeer(RequestCheckUserPayeerModel model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponseCheckUserPayeerModel>(server + "Payeer/checkAccount", model, Method.Post
                , cancellationToken);
            if (response != null && response.IsSuccessful && response.Data != null)
            {
                return response.Data;
            }
            throw new ExternalException($"خطا در استعلام از پایر");
        }

        public async Task<ResponseTransferPayeerModel> purchasePayeer(RequestTransferPayeerModel model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponseTransferPayeerModel>(server + "Payeer/transfer", model, Method.Post
                , cancellationToken);
            if (response != null && response.IsSuccessful && response.Data != null)
            {
                return response.Data;
            }
            return new ResponseTransferPayeerModel();
        }
    }
}
