﻿using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.JibitOnlinePay;
using Farakonesh.Models.API.Sepal;
using Farakonesh.Models.API.Shepa;
using Farakonesh.Shared.Enums;
using RestSharp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public class HttpRequestSepalPPG : IHttpRequestSepalPPG
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestSepalPPG(IRestRequestHelper restRequestHelper,
            IRedisContextService redisContextService)
        {
            _restRequestHelper = restRequestHelper;
            _redisContextService = redisContextService;
        }
        public async Task<string> CheckConnectionPPG(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGSepal, cancellationToken);
            var ping = new System.Net.NetworkInformation.Ping();
            var url = webServiceInfo.BaseUrlService.Replace("https://", "");
            var result = ping.Send(url.Split("/")[0]);

            if (result.Status != System.Net.NetworkInformation.IPStatus.Success)
                return "error-" + "اخطار: ارتباط با درگاه پرداخت سپال برقرار نشد ، باید مطمئن شوید که مشکلی وجود نداشته باشد";
            else
                return "success-" + "سرویس درگاه پرداخت سپال متصل است ، اما به معنای فعال بودن قطعی درگاه پرداخت نیست ، جهت اطمینان روی دکمه ی بررسی درگاه کلیک کنید";
        }
        public async Task<SepalPayResponseModel> PurchaseSepalPPG(SepalPayRequestModel model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<SepalPayResponseModel>(server + "request.json", model, Method.Post
                , cancellationToken);

            if (response.Data != null)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content))
                return response.Content.JsonToT<SepalPayResponseModel>();
            return null;
        }

        public async Task<SepalVerifyResponseModel> VerifySepalPPG(SepalVerifyRequestModel model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<SepalVerifyResponseModel>(server + "verify.json", model, Method.Post
                , cancellationToken);
            if (response != null)
            {
                if (response.Data != null)
                {
                    return response.Data;
                }
                else if (!string.IsNullOrWhiteSpace(response.Content))
                    return response.Content.JsonToT<SepalVerifyResponseModel>();

            }
            return null;
        }

        public async Task<SepalTokenResponseModel> GetToken(string username, string password, string server, CancellationToken cancellationToken)
        {

            var response = await _restRequestHelper.executeAsync<SepalTokenResponseModel>(server + "users/token.json", new { mobile = username, password }, Method.Post
                , cancellationToken);

            if (response.Data != null)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content))
                return response.Content.JsonToT<SepalTokenResponseModel>();

            return null;
        }

        public async Task<SepalGetStateResponseModel> GetState(string paymentNumber, string server,
            string token, CancellationToken cancellationToken)
        {
            
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + token);

            var response = await _restRequestHelper.executeAsync<SepalGetStateResponseModel>(server + "onlinePayments/getState.json", new { paymentNumber }, Method.Post
                , cancellationToken, headers);
      
           if (response.Data != null)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content))
                return response.Content.JsonToT<SepalGetStateResponseModel>();

            return null;
        }

        public async Task<SepalGetStateListResponseModel> GetStateList(SepalInquiryRequestModel command, string server,
     string token, CancellationToken cancellationToken)
        {

            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + token);

            var response = await _restRequestHelper.executeAsync<SepalGetStateListResponseModel>(server + "onlinePayments/inquiry.json", command, Method.Post
                , cancellationToken, headers);

            if (response.Data != null)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content))
                return response.Content.JsonToT<SepalGetStateListResponseModel>();

            return null;
        }
    }
}
