﻿using RestSharp;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Shepa;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestShepaPPG: IHttpRequestShepaPPG
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestShepaPPG(IRestRequestHelper restRequestHelper,
            IRedisContextService redisContextService)
        {
            _restRequestHelper = restRequestHelper;
            _redisContextService = redisContextService;
        }
        public async Task<string> checkConnectionPPG(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGShepa,cancellationToken);
            var ping = new System.Net.NetworkInformation.Ping();
            var url = webServiceInfo.BaseUrlService.Replace("https://", "");
            var result = ping.Send(url.Split("/")[0]);

            if (result.Status != System.Net.NetworkInformation.IPStatus.Success)
                return "error-" + "اخطار: ارتباط با درگاه پرداخت شپا برقرار نشد ، باید مطمئن شوید که مشکلی وجود نداشته باشد";
            else
                return "success-" + "سرویس درگاه پرداخت شپا متصل است ، اما به معنای فعال بودن قطعی درگاه پرداخت نیست ، جهت اطمینان روی دکمه ی بررسی درگاه کلیک کنید";
        }
        public async Task<ResponsePurchasesShepaPPG> purchaseShepaPPG(RequestPurchasesShepaPPG model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponsePurchasesShepaPPG>(server + "token", model, Method.Post
                , cancellationToken);

            if (response != null)
            {
                return response.Data;
            }
            return null;
        }

        public async Task<ResponseVerifyShepaPPG> verifyShepaPPG(RequestVerifyShepaPPG model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponseVerifyShepaPPG>(server + "verify", model, Method.Post
                , cancellationToken);
            if (response != null)
            {
                if (response.Data != null)
                {
                    return response.Data;
                }
                else if (!string.IsNullOrWhiteSpace(response.Content))
                    return response.Content.JsonToT<ResponseVerifyShepaPPG>();

            }
            return null;
        }
    }
}
