﻿using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Kavenegar;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.SmsIr;
using RestSharp;
using Microsoft.AspNetCore.DataProtection.KeyManagement;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestSmsIr: IHttpRequestSmsIr
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestSmsIr(IRestRequestHelper restRequestHelper,
            RedisService redis, ISettingContext iSettingContext, IRedisContextService redisContextService)
        {
            _redisContextService = redisContextService;
            _restRequestHelper = restRequestHelper;

        }
        public async Task<ResponseSmsIr<ResponseSmsIrItem>> SendSms(RequestSmsIr model, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            
            headers.Add("X-API-KEY", model.ApiKey);
            var response = await _restRequestHelper.executeAsync<ResponseSmsIr<ResponseSmsIrItem>>(model.BaseUrl + "send/verify", model
                , Method.Post, cancellationToken, headers);
            return response.Data;
        }
        /// <summary>
        /// دریافت موجودی پنل اس ام اس آی آر
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public async Task<ResponseSmsIr<decimal?>> getCredit(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.SmsIr,cancellationToken);
            var headers = new Dictionary<string, string>();

            headers.Add("X-API-KEY", setting.RealApiKey);
            var parameters = new Dictionary<string, string>();
            var response = await _restRequestHelper.executeAsyncGet<ResponseSmsIr<decimal?>>(setting.BaseUrlService + "credit", parameters
                , cancellationToken, headers);
            return response.Data;
        }
    }
}
