﻿using RestSharp;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.Payeer;
using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.Services.RestRequest
{
    public class HttpRequestTelegram: IHttpRequestTelegram
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestTelegram(IRestRequestHelper restRequestHelper, IRedisContextService redisContextService)
        {
            _restRequestHelper = restRequestHelper;
            _redisContextService = redisContextService;
        }
        public async Task<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<ResponseTelegramSendMessageDataModel>>> sendMessageToBot(RequestSendMessageToBotTelegramModel model, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<ResponseTelegramSendMessageDataModel>>>(model.BaseUrl + "telegrambot/send-message", 
                new { accessKey  = model.KeyAccess, message = model.Message, channel  = model.Channel, token = model.Token}, Method.Post
                , cancellationToken);
            return response.Data;
        }
        public async Task<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<ResponseTelegramBotInfoModel>>> GetInfoBot(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi, cancellationToken);
            var parameters = new Dictionary<string, object>();
            parameters.Add("token", webServiceInfo.RealApiKey);
            parameters.Add("accessKey", setting.JobToken);
            var response = await _restRequestHelper.executeAsyncGet<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<ResponseTelegramBotInfoModel>>>(webServiceInfo.BaseUrlService + "telegrambot/get-bot-info",
                parameters
                , cancellationToken);
            return response.Data;
        }
        public async Task<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<ResponseTelegramChatInfoModel>>> GetInfoChat(string chatId,CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi, cancellationToken);
            var parameters = new Dictionary<string, object>();
            parameters.Add("token", webServiceInfo.RealApiKey);
            parameters.Add("accessKey", setting.JobToken);
            parameters.Add("chatId", chatId);
            var response = await _restRequestHelper.executeAsyncGet<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<ResponseTelegramChatInfoModel>>>(webServiceInfo.BaseUrlService + "telegrambot/get-chat-info",
                parameters
                , cancellationToken);
            return response.Data;
        }
        public async Task<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<bool>>> DeleteHookBot(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi, cancellationToken);
            var parameters = new Dictionary<string, object>();
            parameters.Add("token", webServiceInfo.RealApiKey);
            parameters.Add("accessKey", setting.JobToken);
            var response = await _restRequestHelper.executeAsyncDelete<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<bool>>>(webServiceInfo.BaseUrlService+ "telegrambot/delete-hook",
                parameters, cancellationToken,null);
            return response.Data;
        }

        public async Task<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<ResponseTelegramGetHookBoModel>>> GetHookBot(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi,cancellationToken);
            var parameters = new Dictionary<string, object>();
            parameters.Add("token", webServiceInfo.RealApiKey);
            parameters.Add("accessKey", setting.JobToken);
            var response = await _restRequestHelper.executeAsyncGet<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<ResponseTelegramGetHookBoModel>>>(webServiceInfo.BaseUrlService+ "telegrambot/get-hook-info",
                parameters, cancellationToken, null);
            return response.Data;
        }

        public async Task<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<bool>>> SetHookBot(RequestSetHookToBotTelegramModel model, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi, cancellationToken);
            var response = await _restRequestHelper.executeAsync<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<bool>>>(webServiceInfo.BaseUrlService + "telegrambot/set-hook",
                new { urlAddress = model.UrlAddress,token= webServiceInfo.RealApiKey, accessKey = setting.JobToken }, 
                Method.Post, cancellationToken, null);
            return response.Data;
        }

        public async Task<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<bool>>> LeaveChat(string chatId, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi, cancellationToken);
            var parameters = new Dictionary<string, object>();
            parameters.Add("token", webServiceInfo.RealApiKey);
            parameters.Add("accessKey", setting.JobToken);
            parameters.Add("chatId", chatId);
            var response = await _restRequestHelper.executeAsyncGet<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<bool>>>(webServiceInfo.BaseUrlService + "telegrambot/leave-chat",
     parameters, cancellationToken, null);
            return response.Data;
        }
        public async Task<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<long?>>> GetMemberCount(string chatId, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi, cancellationToken);
            var parameters = new Dictionary<string, object>();
            parameters.Add("token", webServiceInfo.RealApiKey);
            parameters.Add("accessKey", setting.JobToken);
            parameters.Add("chatId", chatId);
            var response = await _restRequestHelper.executeAsyncGet<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<long?>>>(webServiceInfo.BaseUrlService + "telegrambot/get-chat-member-count",
     parameters, cancellationToken, null);
            return response.Data;
        }

        public async Task<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<List<ResponseGetChatAdministratorsItemModel>>>> GetAdministrators(string chatId, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi, cancellationToken);
            var parameters = new Dictionary<string, object>();
            parameters.Add("token", webServiceInfo.RealApiKey);
            parameters.Add("accessKey", setting.JobToken);
            parameters.Add("chatId", chatId);
            var response = await _restRequestHelper.executeAsyncGet<BaseResponseTelegramServiceModel<BaseResponseTelegramServiceDataModel<List<ResponseGetChatAdministratorsItemModel>>>>(webServiceInfo.BaseUrlService + "telegrambot/get-chat-administrators",
     parameters, cancellationToken, null);
            return response.Data;
        }
    }
}
