﻿using RestSharp;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.Vandar;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestVandarPPG: IHttpRequestVandarPPG
    {
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestVandarPPG(IRestRequestHelper restRequestHelper)
        {
            _restRequestHelper = restRequestHelper;
        }
        public async Task<ResponsePurchasesVandarPPG> purchaseVandarPPG(RequestPurchasesVandarPPG model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponsePurchasesVandarPPG>(server + "send", model, Method.Post
                , cancellationToken);

            if (response != null)
            {
                return response.Data;
            }
            return null;
        }

        public async Task<ResponseTransActionVandarPPG> getVandarTransActionPPG(RequestVerifyVandarPPG model
            , string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponseTransActionVandarPPG>(server + "transaction", model, Method.Post
                , cancellationToken);
            if (response != null)
            {
                return response.Data;
            }
            return null;
        }

        public async Task<ResponseVerifyVandarPPG> verifyVandarPPG(RequestVerifyVandarPPG model, string server, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<ResponseVerifyVandarPPG>(server + "verify", model, Method.Post
                , cancellationToken);
            if (response != null)
            {
                if (response.Data != null)
                {
                    return response.Data;
                }
                else if (!string.IsNullOrWhiteSpace(response.Content))
                    return response.Content.JsonToT<ResponseVerifyVandarPPG>();

            }
            return null;
        }

    }
}
