﻿using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Models.API.Whatsapp;
using Farakonesh.Shared.Exceptions;
using RestSharp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public class HttpRequestWhatsapp : IHttpRequestWhatsapp
    {
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestWhatsapp(IRestRequestHelper restRequestHelper)
        {
            _restRequestHelper = restRequestHelper;
        }
        public async Task<int?> sendMessageWesender(SendMessageWhatsappRequestModel model, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("dateAdd", "1");
            headers.Add("receivers", model.Receivers);
            headers.Add("key", model.ApiKey);
            headers.Add("sender", model.Sender);
            var response = await _restRequestHelper.executeAsync<int>(model.BaseUrl + "Send",
                new { message = model.Message }, Method.Post
                , cancellationToken, headers);
            if (string.IsNullOrWhiteSpace(response.Content))
                return null;

            return Convert.ToInt32(response.Content);
        }

        public async Task<BaseWhatsappResonseModel<SendMessageWhatsappResonseModel>> SendMessageAutochat(SendMessageWhatsappRequestModel model, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<BaseWhatsappResonseModel<SendMessageWhatsappResonseModel>>(model.BaseUrl + "v1/whatsapp/send-message",
                new
                {
                    to = model.Receivers,
                    message = model.Message,
                    token = model.ApiKey,
                }, Method.Post
                , cancellationToken, null);
            if (!response.IsSuccessful || response.Data == null)
                throw new ExternalServiceException("خطا در دریافت نتیجه سرویس واتساپ");
            if (response.Data != null && !string.IsNullOrWhiteSpace(response.Data.error))
            {
                throw new ExternalServiceException(response.Data.error);
            }

            return response.Data;
        }
        public async Task<BaseWhatsappResonseModel<SendFileMessageWhatsappResonseModel>> SendFileMessageAutochat(SendFileMessageWhatsappRequestModel model, CancellationToken cancellationToken)
        {
            var response = await _restRequestHelper.executeAsync<BaseWhatsappResonseModel<SendFileMessageWhatsappResonseModel>>(model.BaseUrl + "v1/whatsapp/send-file",
                new
                {
                    to = model.Receivers,
                    caption = model.Caption,
                    token = model.ApiKey,
                    file = model.File
                }, Method.Post
                , cancellationToken, null);
            if (!response.IsSuccessful || response.Data == null)
                throw new ExternalServiceException("خطا در دریافت نتیجه سرویس واتساپ");
            if (response.Data != null && !string.IsNullOrWhiteSpace(response.Data.error))
            {
                throw new ExternalServiceException(response.Data.error);
            }

            return response.Data;
        }

        public async Task<BaseWhatsappResonseModel<GetMeWhatsappResonseModel>> GetMeAutochat(BaseWhatsappRequestModel model, CancellationToken cancellationToken)
        {
            var parameters = new Dictionary<string, string>();
            parameters.Add("token", model.ApiKey);
            var response = await _restRequestHelper.executeAsyncGet<BaseWhatsappResonseModel<GetMeWhatsappResonseModel>>(model.BaseUrl + "v1/whatsapp/me", parameters,
                cancellationToken, null);
            if (!response.IsSuccessful || response.Data == null)
                throw new ExternalServiceException("خطا در دریافت نتیجه سرویس واتساپ");
            if(response.Data != null && !string.IsNullOrWhiteSpace(response.Data.error))
            {
                throw new ExternalServiceException(response.Data.error);
            }
            return response.Data;
        }

        public async Task<BaseWhatsappResonseModel<GetStatusWhatsappResonseModel>> GetStatusAutochat(BaseWhatsappRequestModel model, CancellationToken cancellationToken)
        {
            var parameters = new Dictionary<string, string>();
            parameters.Add("token", model.ApiKey);
            var response = await _restRequestHelper.executeAsyncGet<BaseWhatsappResonseModel<GetStatusWhatsappResonseModel>>(model.BaseUrl + "v1/whatsapp/get-status", parameters,
                cancellationToken, null);
            if (!response.IsSuccessful || response.Data == null)
                throw new ExternalServiceException("خطا در دریافت نتیجه سرویس واتساپ");
            if (response.Data != null && !string.IsNullOrWhiteSpace(response.Data.error))
            {
                throw new ExternalServiceException(response.Data.error);
            }

            return response.Data;
        }
        public async Task<BaseWhatsappResonseModel<GetMessagesWhatsappResonseModel>> GetMessagesAutochat(GetMessagesWhatsappRequestModel model, CancellationToken cancellationToken)
        {

            var parameters = new Dictionary<string, string>();
            parameters.Add("token", model.ApiKey);
            if (model.Per_page != null && model.Per_page > 0)
                parameters.Add("per_page", model.Per_page.ToString());
            if (model.Page != null && model.Page > 0)
                parameters.Add("page", model.Per_page.ToString());
            if (model.Status != null && model.Status > 0)
                parameters.Add("status", model.Status.ToString());

            var response = await _restRequestHelper.executeAsyncGet<BaseWhatsappResonseModel<GetMessagesWhatsappResonseModel>>(model.BaseUrl + "v1/whatsapp/messages", parameters,
                cancellationToken, null);

            if (!response.IsSuccessful || response.Data == null)
                throw new ExternalServiceException("خطا در دریافت نتیجه سرویس واتساپ");
            if (response.Data != null && !string.IsNullOrWhiteSpace(response.Data.error))
            {
                throw new ExternalServiceException(response.Data.error);
            }

            return response.Data;
        }
    }
}
