﻿using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.Whatsapp;
using RestSharp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestWindowsService: IHttpRequestWindowsService
    {
        private readonly IRestRequestHelper _restRequestHelper;
        private readonly IRedisContextService _redisContextService;
        public HttpRequestWindowsService(IRestRequestHelper restRequestHelper,
            IRedisContextService redisContextService)
        {
            _redisContextService = redisContextService;
            _restRequestHelper = restRequestHelper;
        }
        public async Task<object> GetStatus(string serviceName,string typeServer, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingWindowsServiceAsync(cancellationToken);
            string url = "";
            switch (url)
            {
                case "Internal":
                    url = setting.InternalWindowsServiceApi;
                    break;
                case "External":
                    url = setting.ExternalWindowsServiceApi;
                    break;
                case "Auxiliary":
                    url = setting.AuxiliaryWindowsServiceApi;
                    break;
                default:
                    break;
            }
            var headers = new Dictionary<string, string>();
            headers.Add("key-service", setting.JobToken);
            var parameters = new Dictionary<string, string>();
            var response = await _restRequestHelper.executeAsyncGet<object>(url + $"WindowsService/{serviceName}/status", parameters, cancellationToken,headers);
            if (string.IsNullOrWhiteSpace(response.Content) || !response.IsSuccessful)
                return null;

            return response.Data;
        }

        public async Task<object> Get(string serviceName, string typeServer, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingWindowsServiceAsync(cancellationToken);
            string url = "";
            switch (url)
            {
                case "Internal":
                    url = setting.InternalWindowsServiceApi;
                    break;
                case "External":
                    url = setting.ExternalWindowsServiceApi;
                    break;
                case "Auxiliary":
                    url = setting.AuxiliaryWindowsServiceApi;
                    break;
                default:
                    break;
            }
            var headers = new Dictionary<string, string>();
            headers.Add("key-service", setting.JobToken);
            var parameters = new Dictionary<string, string>();
            var response = await _restRequestHelper.executeAsyncGet<object>(url + $"WindowsService/{serviceName}/status", parameters, cancellationToken, headers);
            if (string.IsNullOrWhiteSpace(response.Content) || !response.IsSuccessful)
                return null;

            return response.Data;
        }
    }
}
