﻿using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.Zarinpal;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.ZarinLink;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.ICommonOperations;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestZarinLink : IHttpRequestZarinLink
    {
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestZarinLink(IRestRequestHelper restRequestHelper)
        {
            _restRequestHelper = restRequestHelper;
        }
        public async Task<ResponseGenerateZarinLink> generateZarinLink(RequestGenerateZarinLink model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);
            var body = @"{""query"":""mutation zarinLinkAdd( $terminal_id:ID!, $title: String!,$amount: Int!,$description: String!, $show_receipt: Boolean!,$is_coupon_active: Boolean!,$required_fields: [ZarinLinkRequiredFieldsInput]!, $limit: Int, $successful_redirect_url: String,$failed_redirect_url: String) { resource: ZarinLinkAdd(terminal_id:$terminal_id,title:$title,amount:$amount,description:$description , show_receipt:$show_receipt , is_coupon_active: $is_coupon_active,required_fields:$required_fields , limit:$limit , successful_redirect_url:$successful_redirect_url,failed_redirect_url: $failed_redirect_url ){ id terminal_id link title amount description show_receipt is_coupon_active limit required_fields { input status placeholder } successful_redirect_url failed_redirect_url created_at updated_at deleted_at } }"",""variables"":{""terminal_id"":""{terminal_id}"",""title"":""{title}"",""amount"":{amount},""description"":""{description}"",""is_coupon_active"":false,""show_receipt"":false,""required_fields"":[{""input"":""NAME"",""status"":""HIDDEN"",""placeholder"":""""},{""input"":""EMAIL"",""status"":""HIDDEN"",""placeholder"":""""},{""input"":""MOBILE"",""status"":""HIDDEN"",""placeholder"":""""},{""input"":""DESCRIPTION"",""status"":""HIDDEN"",""placeholder"":""""},{""input"":""CUSTOM_FIELD_1"",""status"":""HIDDEN"",""placeholder"":""""},{""input"":""CUSTOM_FIELD_2"",""status"":""HIDDEN"",""placeholder"":""""}],""limit"":{limit},""successful_redirect_url"":""{successful_redirect_url}"",""failed_redirect_url"":""{failed_redirect_url}""}}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseGenerateZarinLink>(server, body.Replace("{amount}", model.amount.ToString()).Replace("{terminal_id}", model.terminal_id).Replace("{limit}", model.limit.ToString()).Replace("{failed_redirect_url}", model.failed_redirect_url).Replace("{successful_redirect_url}", model.successful_redirect_url).Replace("{description}", model.description).Replace("{title}", model.title)
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }

        public async Task<ResponseGenerateZarinLinkV2> generateZarinLinkV2(RequestGenerateZarinLinkV2 model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);
            var body = @"{""operationName"":""ZarinLinkCreateMutation"",""variables"":{""terminal_id"":""{terminal_id}"",""title"":""{title}"",""amount"":{amount},""description"":""{description}"",""is_coupon_active"":false,""show_receipt"":false,""required_fields"":[{""input"":""NAME"",""status"":""HIDDEN"",""placeholder"":""نام و نام‌خانوادگی""},{""input"":""MOBILE"",""status"":""HIDDEN"",""placeholder"":""شماره موبایل""},{""input"":""EMAIL"",""status"":""HIDDEN"",""placeholder"":""آدرس ایمیل""},{""input"":""DESCRIPTION"",""status"":""HIDDEN"",""placeholder"":""توضیحات سفارش""},{""input"":""CUSTOM_FIELD_1"",""status"":""HIDDEN"",""placeholder"":""""},{""input"":""CUSTOM_FIELD_2"",""status"":""HIDDEN"",""placeholder"":""""}],""limit"":null,""successful_redirect_url"":""{successful_redirect_url}"",""failed_redirect_url"":""{failed_redirect_url}"",""amount_type"":""FIX"",""type"":""PAYMENT""},""query"":""mutation ZarinLinkCreateMutation($terminal_id: ID!, $title: String!, $amount: Int!, $description: String!, $show_receipt: Boolean!, $is_coupon_active: Boolean!, $required_fields: [ZarinLinkRequiredFieldsInput], $limit: Int, $type: ZarinLinkTypeEnum, $successful_redirect_url: String, $failed_redirect_url: String, $amount_type: ZarinLinkAmountTypeEnum, $meta_data: ZarinLinkMetaDataInput, $specifications: [ZarinLinkSpecificationInput], $category_id: Int) {\n  NewZarinLinkAdd(\n    terminal_id: $terminal_id\n    title: $title\n    amount: $amount\n    description: $description\n    show_receipt: $show_receipt\n    is_coupon_active: $is_coupon_active\n    required_fields: $required_fields\n    limit: $limit\n    successful_redirect_url: $successful_redirect_url\n    failed_redirect_url: $failed_redirect_url\n    type: $type\n    amount_type: $amount_type\n    meta_data: $meta_data\n    specifications: $specifications\n    category_id: $category_id\n  ) {\n    id\n    __typename\n  }\n}""}
" + "\n" +
@"";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseGenerateZarinLinkV2>(server, body.Replace("{amount}", model.amount.ToString()).Replace("{terminal_id}", model.terminal_id).Replace("{failed_redirect_url}", model.failed_redirect_url).Replace("{successful_redirect_url}", model.successful_redirect_url).Replace("{description}", model.description).Replace("{title}", model.title)
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }

        public async Task<ResponseCancelZarinLink> cancelZarinLink(RequestCancelZarinLink model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);
            var body = @"{""operationName"":""ZarinLinkRemove"",""variables"":{""id"":""{id}""},""query"":""mutation ZarinLinkRemove($id: ID!) {\n  ZarinLinkRemove(id: $id)\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseCancelZarinLink>(server, body.Replace("{id}", model.id)
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }

        public async Task<ResponseGetZarinLink> getZarinLink(RequestGetZarinLink model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);
            var body = @"{""operationName"":""GetNewZarinLinks"",""variables"":{""limit"":{limit},""offset"":{offset},""terminal_id"":""{terminal_id}""},""query"":""query GetNewZarinLinks($id: ID, $type: ZarinLinkTypeEnum, $terminal_id: ID, $title: String, $offset: Int, $amount_type: ZarinLinkAmountTypeEnum, $amount: Int, $max_amount: Int, $min_amount: Int, $description: String, $successful_redirect_url: String, $limit: Int, $filter: ZarinLinkFilterEnum) {\n  NewZarinLinks: NewZarinLinks(\n    id: $id\n    type: $type\n    terminal_id: $terminal_id\n    title: $title\n    amount_type: $amount_type\n    amount: $amount\n    max_amount: $max_amount\n    min_amount: $min_amount\n    offset: $offset\n    description: $description\n    successful_redirect_url: $successful_redirect_url\n    failed_redirect_url: $successful_redirect_url\n    filter: $filter\n    limit: $limit\n    pagination: true\n  ) {\n    id\n    link\n    title\n    limit\n    type\n    created_at\n    deleted_at\n    amount\n    amount_type\n    images {\n      url\n      __typename\n    }\n    __typename\n  }\n  Pagination {\n    total\n    last_page\n    __typename\n  }\n}""}
" + "\n" +
@"";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseGetZarinLink>(server, body.Replace("{terminal_id}", model.terminal_id).Replace("{offset}", model.offset.ToString()).Replace("{limit}", model.limit.ToString())
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }

        public async Task<ResponseGetZarinLink> getZarinLinkById(RequestGetZarinLink model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);
            var body = @"{""operationName"":""GetZarinLinkById"",""variables"":{""id"":""{id}"",""terminal_id"":""{terminal_id}"",""type"":""PAYMENT""},""query"":""query GetZarinLinkById($terminal_id: ID, $id: ID, $type: ZarinLinkTypeEnum) {\n  NewZarinLinks(terminal_id: $terminal_id, id: $id, type: $type) {\n    id\n    title\n    link\n    description\n    show_receipt\n    is_coupon_active\n    amount\n    limit\n    deleted_at\n    updated_at\n    created_at\n    required_fields {\n      input\n      status\n      placeholder\n      __typename\n    }\n    successful_redirect_url\n    failed_redirect_url\n    amount_type\n    type\n    specifications {\n      key\n      value\n      __typename\n    }\n    meta_data {\n      start_date\n      start_time\n      end_time\n      end_date\n      event_type\n      province\n      city\n      address\n      url\n      target_amount\n      __typename\n    }\n    category {\n      id\n      title\n      parent {\n        id\n        title\n        __typename\n      }\n      __typename\n    }\n    images {\n      id\n      url\n      __typename\n    }\n    coupons {\n      id\n      discount_percent\n      code\n      __typename\n    }\n    __typename\n  }\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseGetZarinLink>(server, body.Replace("{terminal_id}", model.terminal_id).Replace("{id}", model.id)
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }

        public async Task<ResponseGetTransactionZarinLink> getTransactionListByZarinLinkId(RequestGetTransactionZarinLink model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);
            var body = @"{""operationName"":""GetSessions"",""variables"":{""filter"":""{filter}"",""limit"":{limit},""offset"":{offset},""relation_id"":""{id}"",""terminal_id"":""{terminal_id}""},""query"":""query GetSessions($reconciliation_id: ID, $filter: FilterEnum, $terminal_id: ID, $offset: Int, $limit: Int, $type: SessionTypeEnum, $amount: Int, $max_amount: Int, $min_amount: Int, $created_from_date: DateTime, $created_to_date: DateTime, $id: ID, $reference_id: String, $relation_id: ID, $mobile: CellNumber, $email: String, $description: String, $card_pan: String, $rrn: String) {\n  Session: Session(\n    filter: $filter\n    type: $type\n    terminal_id: $terminal_id\n    offset: $offset\n    limit: $limit\n    amount: $amount\n    max_amount: $max_amount\n    min_amount: $min_amount\n    mobile: $mobile\n    created_from_date: $created_from_date\n    created_to_date: $created_to_date\n    id: $id\n    reference_id: $reference_id\n    pagination: true\n    relation_id: $relation_id\n    card_pan: $card_pan\n    email: $email\n    description: $description\n    rrn: $rrn\n    reconciliation_id: $reconciliation_id\n  ) {\n    id\n    type\n    status\n    created_at\n    description\n    reconciliation_id\n    amount\n    fee\n    timeline {\n      refund_id\n      refund_status\n      reconciled_id\n      reconciled_time\n      reconciled_status\n      __typename\n    }\n    __typename\n  }\n  Pagination {\n    total\n    last_page\n    __typename\n  }\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseGetTransactionZarinLink>(server, body.Replace("{terminal_id}", model.terminal_id).Replace("{id}", model.relation_id).Replace("{filter}", model.filter).Replace("{offset}", model.offset.ToString()).Replace("{limit}", model.limit.ToString())
                ,  cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }

        public async Task<ResponseGetTransactionByIdZarinLink> getTransactionByIdByZarinLinkId(RequestGetTransactionZarinLink model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);
            var body = @"{""operationName"":""SessionById"",""variables"":{""id"":""{id}"",""terminal_id"":""{terminal_id}""},""query"":""query SessionById($terminal_id: ID, $id: ID) {\n  Session(terminal_id: $terminal_id, id: $id) {\n    id\n    note\n    notes {\n      id\n      content\n      __typename\n    }\n    reference_id\n    reconciliation_id\n    type\n    fee\n    fee_type\n    status\n    amount\n    authority\n    description\n    created_at\n    payer_info {\n      card_holder_name\n      description\n      email\n      mobile\n      name\n      order_id\n      zarin_link_id\n      custom_field_1_name\n      custom_field_2_name\n      custom_field_1\n      custom_field_2\n      __typename\n    }\n    terminal {\n      id\n      refund_active\n      __typename\n    }\n    session_tries {\n      is_card_mobile_verified\n      card_info {\n        name\n        slug\n        __typename\n      }\n      agent {\n        country_code\n        __typename\n      }\n      card_pan\n      payer_ip\n      rrn\n      status\n      __typename\n    }\n    refund {\n      id\n      session_id\n      instant_payout {\n        id\n        amount\n        fee\n        terminal {\n          id\n          __typename\n        }\n        bank_account {\n          id\n          iban\n          holder_name\n          issuing_bank {\n            name\n            slug\n            slug_image\n            __typename\n          }\n          __typename\n        }\n        reference_id\n        reconciled_at\n        created_at\n        status\n        __typename\n      }\n      __typename\n    }\n    product {\n      title\n      __typename\n    }\n    timeline {\n      canceled_time\n      created_time\n      in_bank_name\n      in_bank_time\n      reconciled_id\n      reconciled_time\n      reconciled_status\n      reconciled_success_time\n      settled_time\n      verified_reference\n      verified_time\n      refund_status\n      refund_amount\n      refund_time\n      __typename\n    }\n    __typename\n  }\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseGetTransactionByIdZarinLink>(server, body.Replace("{terminal_id}", model.terminal_id).Replace("{id}", model.relation_id)
                , cancellationToken, headers);

            if (response.IsSuccessful || (response.Data.data != null && response.Data.data.Session != null
                && response.Data.data.Session.Count > 0))
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }

        public async Task<ResponseZarinLinkCurrentBalance> GetCurrentBalance(string terminalId, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);
            var body = @"{""operationName"":""GetPayoutBalance"",""variables"":{""terminal_id"":""{terminal_id}""},""query"":""query GetPayoutBalance($terminal_id: ID!) {\n  PayoutBalance: PayoutBalance(terminal_id: $terminal_id) {\n    value\n    __typename\n  }\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseZarinLinkCurrentBalance>(server, body.Replace("{terminal_id}", terminalId)
                , cancellationToken, headers);

            if (response.IsSuccessful || (response.Data.data != null && response.Data.data.PayoutBalance != null))
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }
        public async Task<ResponseGetBankAccountZarinLink> getBankAccount(string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);
            var body = @"{""operationName"":""BankAccountDetail"",""variables"":{""limit"":200},""query"":""query BankAccountDetail($offset: Int, $limit: Int, $iban_holder_name: String) {\n  BankAccounts(\n    offset: $offset\n    limit: $limit\n    iban_holder_name: $iban_holder_name\n  ) {\n    id\n    iban\n    status\n    is_legal\n    holder_name\n    type\n    pin\n    issuing_bank {\n      name\n      slug_image\n      slug\n      __typename\n    }\n    expired_at\n    deleted_at\n    __typename\n  }\n  Pagination {\n    name\n    limit\n    last_page\n    __typename\n  }\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseGetBankAccountZarinLink>(server, body
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }
        public async Task<ResponseSettlementZarinLink> settlementZarinLinkSetting(RequestSettlementZarinLink model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);

            var body = @"{""operationName"":""TerminalEdit"",""variables"":{""id"":""{id}"",""bank_account_id"":""{bank_account_id}"",""reconcile_priority"":""{reconcile_priority}""},""query"":""mutation TerminalEdit($id: ID!, $logo: ValidFile, $bank_account_id: ID, $reconcile_priority: ReconcileCycleTypeEnum, $support_phone: CellNumber, $server_ip: IP, $fee_type: TerminalFeeTypeEnum, $chn_type: TerminalChnTypeEnum, $psp_priority: [String]) {\n  TerminalEdit(\n    id: $id\n    logo: $logo\n    bank_account_id: $bank_account_id\n    reconcile_priority: $reconcile_priority\n    support_phone: $support_phone\n    server_ip: $server_ip\n    fee_type: $fee_type\n    chn_type: $chn_type\n    psp_priority: $psp_priority\n  ) {\n    id\n    chn_type\n    logo\n    __typename\n  }\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseSettlementZarinLink>(server, body.Replace("{id}", model.id).Replace("{bank_account_id}", model.bank_account_id).Replace("{reconcile_priority}", model.reconcile_priority)
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }

            return null;
        }

        public async Task<ResponseSetCardHolder> SetCardHolder(string trackingCode, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);

            var body = @"{""operationName"":""SessionCardHolder"",""variables"":{""session_id"":""{id}""},""query"":""mutation SessionCardHolder($session_id: ID!) {\n  SessionCardHolder(session_id: $session_id)\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseSetCardHolder>(server, body.Replace("{id}", trackingCode)
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }

            return null;
        }

        public async Task<ResponseRefundZarinLink> AddRefund(RequestRefundZarinLink model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", token);

            var body = @"{""operationName"":""AddRefund"",""variables"":{""amount"":""{amount}"",""description"":""{description}"",""reason"":""{reason}"",""method"":""{method}"",""session_id"":""{session_id}""},""query"":""mutation AddRefund($session_id: ID!, $amount: BigInteger!, $description: String, $reason: RefundReasonEnum, $method: InstantPayoutActionTypeEnum) {\n  AddRefund(\n    session_id: $session_id\n    amount: $amount\n    description: $description\n    reason: $reason\n    method: $method\n  ) {\n    id\n    amount\n    fee\n    terminal_id\n    timeline {\n      created_time\n      created_reference\n      canceled_time\n      in_bank_time\n      in_bank_name\n      verified_time\n      verified_reference\n      reconciled_time\n      refund_amount\n      refund_time\n      __typename\n    }\n    __typename\n  }\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseRefundZarinLink>(server, body.Replace("{amount}", model.amount.ToString()).Replace("{description}", model.description).Replace("{reason}", model.reason).Replace("{method}", model.method).Replace("{session_id}", model.session_id)
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }

            return null;
        }
    }
}
