﻿using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.JibitOnlinePay;
using Farakonesh.Models.API.Zarinpal;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Newtonsoft.Json.Linq;
using RestSharp;
using System;
using System.Collections.Generic;
using System.Reflection.Metadata;
using System.Text;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Services.RestRequest
{
    public sealed class HttpRequestZarinpalPPG : IHttpRequestZarinpalPPG
    {
        private readonly IRedisContextService _redisContextService;
        private readonly IRestRequestHelper _restRequestHelper;
        public HttpRequestZarinpalPPG(IRedisContextService redisContextService, IRestRequestHelper restRequestHelper)
        {
            _restRequestHelper = restRequestHelper;
            _redisContextService = redisContextService;
        }

        public async Task<string> checkConnectionPPG(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.PPGZarinpal, cancellationToken);

            var ping = new System.Net.NetworkInformation.Ping();
            var url = webServiceInfo.BaseUrlService.Replace("https://", "");
            var result = ping.Send(url.Split("/")[0]);

            if (result.Status != System.Net.NetworkInformation.IPStatus.Success)
                return "error-" + "اخطار: ارتباط با درگاه پرداخت زرین پال برقرار نشد ، باید مطمئن شوید که مشکلی وجود نداشته باشد";
            else
                return "success-" + "سرویس درگاه پرداخت زرین پال متصل است ، اما به معنای فعال بودن قطعی درگاه پرداخت نیست ، جهت اطمینان روی دکمه ی بررسی درگاه کلیک کنید";


        }

        public async Task<ResponsePurchasesZarinpalMainPPG> purchaseZarinpalPPG(RequestPurchasesZarinpalPPG model
            , string server, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            var response = await _restRequestHelper.executeAsync<ResponsePurchasesZarinpalPPG>(server + "pg/v4/payment/request.json", model, Method.Post
                , cancellationToken, headers);

            if (response != null && response.Data != null)
            {

                if (response.Data.data == null || response.Data.data.GetType().IsArray || (response.Data.data.getValue("ValueKind") != null && ((JsonElement)response.Data.data).ValueKind == JsonValueKind.Array))
                {
                    return new ResponsePurchasesZarinpalMainPPG() { errors = response.Data.errors.ToString().JsonToT<ResponseErrorsZarinpalPPG>(), data = null };
                }
                else
                {
                    var responseObject = new ResponsePurchasesZarinpalMainPPG() { data = response.Data.data.ToString().JsonToT<ResponsePurchasesZarinpalPPGData>(), errors = null };
                    if (string.IsNullOrWhiteSpace(responseObject.data.authority) && response.Data.errors != null)
                    {
                        return new ResponsePurchasesZarinpalMainPPG() { errors = response.Data.errors.ToString().JsonToT<ResponseErrorsZarinpalPPG>(), data = null };
                    }
                    return responseObject;
                }

            }
            return null;
        }


        public async Task<ResponsePurchasesZarinpalMainPPG> verifyZarinpalPPG(RequestVerifyPurchasesZarinpalPPG model, string server, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            var response = await _restRequestHelper.executeAsync<ResponsePurchasesZarinpalPPG>(server + "pg/v4/payment/verify.json", model, Method.Post
                , cancellationToken, headers);

            if (response != null && response.Data != null)
            {
                if (response.Data.data == null || response.Data.data.GetType().IsArray || (response.Data.data.getValue("ValueKind") != null && ((JsonElement)response.Data.data).ValueKind == JsonValueKind.Array))
                {
                    return new ResponsePurchasesZarinpalMainPPG() { errors = response.Data.errors.ToString().JsonToT<ResponseErrorsZarinpalPPG>(), data = null };
                }
                else
                {
                    return new ResponsePurchasesZarinpalMainPPG() { data = response.Data.data.ToString().JsonToT<ResponsePurchasesZarinpalPPGData>(), errors = null };
                }

            }
            return null;
        }

        public async Task<ResponsePurchasesZarinpalPPGUnverifiedMain> getUnVerifiedZarinpalPPG(RequestVerifyPurchasesZarinpalPPG model, string server, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            var response = await _restRequestHelper.executeAsync<ResponsePurchasesZarinpalPPG>(server + "pg/v4/payment/unVerified.json", model, Method.Post
                , cancellationToken, headers);

            if (response != null && response.Data != null)
            {
                if (response.Data.data == null || response.Data.data.GetType().IsArray || (response.Data.data.getValue("ValueKind") != null && ((JsonElement)response.Data.data).ValueKind == JsonValueKind.Array))
                {
                    return new ResponsePurchasesZarinpalPPGUnverifiedMain() { errors = response.Data.errors.ToString().JsonToT<ResponseErrorsZarinpalPPG>(), data = null };
                }
                else
                {
                    return new ResponsePurchasesZarinpalPPGUnverifiedMain() { data = response.Data.data.ToString().JsonToT<ResponsePurchasesZarinpalPPGUnverifiedData>(), errors = null };
                }

            }
            return null;
        }

        public async Task<ResponseTransactionListZarinpalPPG> getZarinpalTransActionPPG(RequestTransactionListZarinpalPPG model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + token);
            var body = @"{""operationName"":""GetSessions"",""variables"":{""filter"":""FILTERVALUE"",""limit"":{LIMIT},""offset"":{OFFSET},""terminal_id"":""TERMINALVALUE""},""query"":""query GetSessions($reconciliation_id: ID, $filter: FilterEnum, $terminal_id: ID, $offset: Int, $limit: Int, $type: SessionTypeEnum, $amount: Int, $max_amount: Int, $min_amount: Int, $created_from_date: DateTime, $created_to_date: DateTime, $id: ID, $reference_id: String, $relation_id: ID, $mobile: CellNumber, $email: String, $description: String, $card_pan: String, $rrn: String) {\n  Session: Session(\n    filter: $filter\n    type: $type\n    terminal_id: $terminal_id\n    offset: $offset\n    limit: $limit\n    amount: $amount\n    max_amount: $max_amount\n    min_amount: $min_amount\n    mobile: $mobile\n    created_from_date: $created_from_date\n    created_to_date: $created_to_date\n    id: $id\n    reference_id: $reference_id\n    pagination: true\n    relation_id: $relation_id\n    card_pan: $card_pan\n    email: $email\n    description: $description\n    rrn: $rrn\n    reconciliation_id: $reconciliation_id\n  ) {\n    id\n    type\n    status\n    created_at\n    description\n    reconciliation_id\n    amount\n    fee\n    timeline {\n      refund_id\n      refund_status\n      reconciled_id\n      reconciled_time\n      reconciled_status\n      __typename\n    }\n    __typename\n  }\n  Pagination {\n    total\n    last_page\n    __typename\n  }\n}""}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseTransactionListZarinpalPPG>(server, body.Replace("FILTERVALUE",model.filter).Replace("TERMINALVALUE",model.terminal_id).Replace("{LIMIT}", model.limit.ToString()).Replace("{OFFSET}", model.offset.ToString())
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }

        public async Task<ResponseTransactionZarinpalPPGReference> getZarinpalTransActionPPGByReference(RequestTransactionListZarinpalPPG model, string server, string token, CancellationToken cancellationToken)
        {
            var headers = new Dictionary<string, string>();
            headers.Add("Authorization", "Bearer " + token);
            var body = @"{""query"":""query getSessions($reconciliation_id: ID,$text:String,$terminal_id:ID, $reference_id:String,$filter:FilterEnum,$order: OrderEnum, $id:ID,$offset:Int,$limit:Int, $type: SessionTypeEnum, $relation_id: ID, $card_pan:String, $description:String, $mobile:CellNumber,$email:String,$created_from_date:DateTime,$created_to_date:DateTime,$amount:Int,$rrn:String,$max_amount: Int,$min_amount: Int) {             resource: Session(reconciliation_id:$reconciliation_id,text:$text ,terminal_id: $terminal_id, reference_id: $reference_id,filter:$filter,order:$order, id:$id, offset:$offset, limit:$limit, type: $type, relation_id: $relation_id, card_pan:$card_pan, description:$description, mobile:$mobile, email:$email, created_to_date:$created_to_date, created_from_date:$created_from_date,amount:$amount,rrn:$rrn,min_amount:$min_amount,max_amount:$max_amount ,pagination:true) {               id               refund{                 id               }               timeline{               refund_status                 refund_amount                 refund_time                                }               reference_id               reconciliation_id               type               fee_type               status               amount               description               created_at               }               pagination:Pagination{               name               limit               last_page             }       }"",""variables"":{""terminal_id"":""TERMINALVALUE"",""order"":"""",""filter"":""FILTERVALUE"",""offset"":{OFFSET},""limit"":{LIMIT},""reference_id"":""REFERENCEVALUE""}}";
            var response = await _restRequestHelper.executeGraphqlAsync<ResponseTransactionZarinpalPPGReference>(server, body.Replace("FILTERVALUE", model.filter).Replace("TERMINALVALUE", model.terminal_id).Replace("REFERENCEVALUE",model.reference_id).Replace("{LIMIT}", model.limit.ToString()).Replace("{OFFSET}", model.offset.ToString())
                , cancellationToken, headers);

            if (response.IsSuccessful)
            {
                return response.Data;
            }
            else if (response.Data != null && response.Data.errors != null && response.Data.errors.Count > 0)
            {
                throw new ExternalServiceException(response.Data.errors[0].message);
            }
            return null;
        }
    }
}
