﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace Farakonesh.Models.API.Payeer
{
    public class RequestTransferPayeerModel:RequestBasePayeerModel
    {
        /// <summary>
        /// نماد ارزی که قرار هست انتقال داده شود --USD --RUB
        /// </summary>
        public string curIn { get; set; }
        /// <summary>
        /// مبلغ درخواستی کاربر که قرار هست منتقل شود
        /// </summary>
        public decimal? sum { get; set; }
        /// <summary>
        /// نماد ارزی که مشتری درخواست شارژش را دارد --- این مورد بطور اتوماتیک توسط خود پایر تبدیل خواهد شد
        /// </summary>
        public string curOut { get; set; }
        // مبلغی که در نهایت برای قرار است منتقل شود
        public decimal? sumOut { get; set; }
        /// <summary>
        /// اکانت/ایمیل پایر مشتری
        /// </summary>
        public string to { get; set; }
        /// <summary>
        /// کامنت انتقال
        /// </summary>
        public string comment { get; set; }
        /// <summary>
        /// کد حفاظتی برای انتقال - اختیاری هست و نیاز به پیاده سازی ندارد
        /// </summary>
        public string protect { get; set; }
        /// <summary>
        /// زمان اعتبار کد حفاظتی - اختیاری هست و نیاز به پیاده سازی ندارد
        /// </summary>
        public int? protectPeriod { get; set; }
        /// <summary>
        /// شماره حفاظتی - اختیاری هست و نیاز به پیاده سازی ندارد
        /// </summary>
        public int? protectCode { get; set; }
        /// <summary>
        /// شناسه سفارش - باید یکتا باشد و از سمت سیستم ما تولید گردد
        /// </summary>
        public string referenceId { get; set; }


    }
}
