﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Models.Database.StoredProcedures.App.Order.AccountNumber
{
    public class GetAccountNumberHistory
    {
        public class Inputs : BaseSearchParams
        {
            public Guid? AccountNumberHistoryId { get; set; }
            public Guid? AccountNumberId { get; set; }
            public int? OrderType { get; set; }
            public string Search { get; set; }
            public long? OrderNumber { get; set; }
            public string CardNumber { get; set; }

        }

        public class Outputs
        {
            public string AccountOwnerFullName { get; set; }
            public string CardNumber { get; set; }
            public string DepositNumber { get; set; }
            public string ShebaNumber { get; set; }
            public Guid? AccountNumberId { get; set; }
            public int? OrderType { get; set; }
            public DateTime? SaveDate { get; set; }
            public bool? IsActive { get; set; }
            public string OrderTypeName { get; set; }
            public decimal? MinAmount { get; set; }
            public string Description { get; set; }
            public decimal? MaxAmount { get; set; }
            public bool? DescriptionOnly { get; set; }
            public bool? IsSmartPayment { get; set; }
            public int? MaximumNumberOfTransactionsPerMonth { get; set; }
            public long? MaximumTransactionAmountPerMonth { get; set; }
            public DateTime? ChangeDate { get; set; }
            public Guid? AccountNumberHistoryId { get; set; }
            public long? Amount { get; set; }
            public decimal? FinalAmount { get; set; }
            public Guid? WalletId { get; set; }
            public Guid? OrderId { get; set; }
            public string Name { get; set; }
            public string Family { get; set; }
            public string NameWallet { get; set; }
            public string FamilyWallet { get; set; }
            public string Mobile { get; set; }
            public string MobileWallet { get; set; }
            public string Email { get; set; }
            public string EmailWallet { get; set; }
            public long? OrderNumber { get; set; }
            public Guid? BankId { get; set; }
            public string BankTitle { get; set; }
            public Guid? BankAvatarId { get; set; }
        }
    }
}
