﻿using Farakonesh.Shared.Validations;
using System;
using System.Collections.Generic;
using System.Security.Principal;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.Order
{
	public sealed class Insert_OrderApplicationFeeByCustomer
	{
		public class Inputs : BaseInsertOrderModel
        {
			[RequiredFieldText("آدرس صفحه لاگین")]
			public string Address { get; set; }
            [RequiredFieldText("نام کاربری")]
            public string UserName { get; set; }
            [RequiredFieldText("رمز")]
            public string Password { get; set; }
			public Guid? FileId { get; set; }

			[RequiredPositiveNumber("مقدار ارز")]
			public decimal? Amount { get; set; }
			public string NameInEnglish { get; set; }
			public string FamilyInEnglish { get; set; }
			public int? ApplicationFeeType { get; set; }
            public DateTime? Deadline { get; set; }
            public int? SaveLocation { get; set; }
        }

		public class Outputs
		{
			public string Email { get; set; }
			public string Mobile { get; set; }
			public Guid? OrderId { get; set; }
		}
	}
}
