﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.Order.Currency
{
    public class Get_CurrencyWarehouse_Admin
    {
        public class Inputs : BaseSearchParams
        {
            public Guid? CurrencyWarehouseId { get; set; }
            public bool? IsCash { get; set; }
            public string Search { get; set; }
            public bool? HaveAmount { get; set; }
            public int? Category { get; set; }
            public DateTime? FromDate { get; set; }
            public DateTime? ToDate { get; set; }
            public TimeSpan? FromTime { get; set; }
            public TimeSpan? ToTime { get; set; }
            public Guid? CurrencyId { get; set; }
        }

        public class Outputs
        {
            public string Code { get; set; }
            public Guid? CurrencyId { get; set; }
            public string Title { get; set; }
            public Guid? CurrencyWarehouseId { get; set; }
            public string Key { get; set; }
            public DateTime? LastDateOfSale { get; set; }
            public string Mark { get; set; }
            public DateTime? PackageEndDate { get; set; }
            public decimal? PriceCurrency { get; set; }
            public decimal? ReceivedStockNumber { get; set; }
            public DateTime? SaveDate { get; set; }
            public decimal? RemainingStockNumber { get; set; }
            /// <summary>
            /// قیمت آخرین فروش از بسته ی ارزی به تومان
            /// </summary>
            public decimal? LastSellPrice { get; set; }
            /// <summary>
            /// قیمت آخرین خرید و ورود ارز به بسته به تومان
            /// </summary>
            public decimal? LastBuyPrice { get; set; }
            /// <summary>
            /// مجموع فروش از بسته ی ارزی مورد نظر به تومان
            /// </summary>
            public decimal? AllSalesOfToman { get; set; }
            /// <summary>
            /// مجموع خرید و ورود ارز به بسته ی ارزی به تومان
            /// </summary>
            public decimal? AllBuyOfToman { get; set; }
            /// <summary>
            /// مجموع فروش از بسته ی ارزی مورد نظر
            /// </summary>
            public decimal? AllSales { get; set; }
            /// <summary>
            /// جمع تعداد وارد شده ارز
            /// </summary>
            public decimal? AllPurchases { get; set; }
            public bool? IsCash { get; set; }
            public string Description { get; set; }
            public bool? IsManual { get; set; }
            /// <summary>
            /// اگر بسته بصورت دستی ثبت شده باشد : ثبت کننده بسته ی ارزی
            /// </summary>
            public string CreatorAdmin { get; set; }
            /// <summary>
            /// اگر بسته بصورت اتوماتیک ایجاد شده باشد: شماره سفارشی که باعث ایجاد بسته شده است
            /// </summary>
            public long? OrderNumberCreator { get; set; }
            public string SourceCurrencyPackage { get; set; }
            /// <summary>
            /// جمع سود حاصل از فروش ارز های بسته
            /// </summary>
            public decimal? SalesProfit { get; set; }
            public long? TotalWage { get; set; }
            public decimal? TotalMediatorWage { get; set; }
            public decimal? SalesOrderProfit { get; set; }
            public int? Category { get; set; }
            public string CategoryTitle { get; set; }
        }
    }
}
