﻿using System;
using System.Collections.Generic;
using System.Numerics;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.Order
{
	/// <summary>
	/// مدل پراسیژر دریافت اطلاعات سفارش با شناسه ی آن
	/// </summary>
	public class GetOrderById
	{
		public class Inputs : BaseInputModel
		{
			/// <summary>
			/// شناسه سفارش
			/// </summary>
			public Guid? OrderId { get; set; }
			/// <summary>
			/// کد تخفیف
			/// </summary>
			public string Code { get; set; }
		}

		public class Outputs
		{
			/// <summary>
			/// شناسه سفارش
			/// </summary>
			public Guid? OrderId { get; set; }
			public string Email { get; set; }
			public DateTime? ChangeDate { get; set; }
			public DateTime? SaveDate { get; set; }
			public string Family { get; set; }
			public string Name { get; set; }
			public decimal? FinalAmount { get; set; }
			public int? Gender { get; set; }
			public string Mobile { get; set; }
			public string NationalCode { get; set; }
			public long? OrderNumber { get; set; }
			public int? OrderType { get; set; }
			public string OrderTypeName { get; set; }
			public int? Status { get; set; }
			public string StatusName { get; set; }
			public string Tel { get; set; }
			public Guid? UserId { get; set; }
			public string ReasonCancellation { get; set; }
			public bool? IsLegal { get; set; }
			public string NationalId { get; set; }
			public string RegistrationNumber { get; set; }
			public string NameOfCompany { get; set; }
			public string AddressOfCompany { get; set; }
			public string TelOfCompany { get; set; }
			public int? PaymentMethod { get; set; }
            public decimal? PaidAmount { get; set; }
			public decimal? FinalAmountBeforeDiscount { get; set; }
			public decimal? DiscountedFinalAmount { get; set; }
			public decimal? Discount { get; set; }
            public int? DiscountType { get; set; }
			public string DiscountTitle { get; set; }
			public string DiscountCode { get; set; }
            public string AdditionalValues { get; set; }
			public DateTime? ExpireDate { get; set; }
			public DateTime? DateNow { get; set; }
            public int? SuccessTransactionCount { get; set; }
            public int? FailedTransactionCount { get; set; }
            public bool? IsCompanyIntroductionCode { get; set; }
            public string TitleCompany { get; set; }
            public Int16? Score { get; set; }
            public string Comment { get; set; }
            public string SaveLocationTitle { get; set; }
            public int? SaveLocation { get; set; }
            public string CountryTitleUser { get; set; }
            public string PrefixPhoneUser { get; set; }
            public string Value { get; set; }
            public decimal? FinalWageAmount { get; set; }
            public int? VariableWageType { get; set; }
            public decimal? FixedWage { get; set; }
            public decimal? VariableWage { get; set; }
            public int? WeightType { get; set; }
            public string WeightTypeTitle { get; set; }
            public string FullAddress { get; set; }
            public decimal? Weight { get; set; }
            public decimal? WeightFee { get; set; }
            public int? WeightFeeType { get; set; }
            public string WeightFeeTypeTitle { get; set; }
            public decimal? ProportionFactorWage { get; set; }
            public decimal? ProportionFactorWageWeight { get; set; }
        }
	}
}
