﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.Order
{
	public class GetOrdersAdmin
	{
		public class Inputs : BaseSearchParams
		{
			public DateTime? FromDate { get; set; }
			public DateTime? ToDate { get; set; }
			public Guid? UserId { get; set; }
			public int? Status { get; set; }
			public string Search { get; set; }
			public int? OrderType { get; set; }
			public bool? NotResolve { get; set; }
            public bool? IsLegal { get; set; }
            public long? OrderNumber { get; set; }
            public bool? DiscountStatus { get; set; }
            public decimal? MaxFinalAmount { get; set; }
            public decimal? MinFinalAmount { get; set; }
            /// <summary>
            /// لیست نوع های سفارش
            /// </summary>
            public string OrderTypeList { get; set; }
            /// <summary>
            /// روش پرداخت
            /// </summary>
            public int? PaymentMethod { get; set; }
			public string StatusList { get; set; }
            public TimeSpan? FromTime { get; set; }
            public TimeSpan? ToTime { get; set; }
            public bool? SeparateDateTimeFilter { get; set; }
            public int? ModuleType { get; set; }
        }

		public class Outputs
		{
			public Guid? OrderId { get; set; }
			public string Email { get; set; }
			public DateTime? ChangeDate { get; set; }
			public DateTime? SaveDate { get; set; }
			public string Family { get; set; }
			public string Name { get; set; }
			public decimal? FinalAmount { get; set; }
			public string Mobile { get; set; }
			public long? OrderNumber { get; set; }
			public string OrderTypeName { get; set; }
			public int? Status { get; set; }
			public string StatusName { get; set; }
			public Guid? UserId { get; set; }
			public bool? ForAdmin { get; set; }
			public bool? IsSeen { get; set; }
            public DateTime? ExpireDate { get; set; }
            public bool? ForCompany { get; set; }
            public bool? IsCompanyIntroductionCode { get; set; }
            public bool? IsUserIntroductionCode { get; set; }
            public Int16? Score { get; set; }
            public decimal? PureIncome { get; set; }
            public decimal? TotalExpenses { get; set; }
            public DateTime? Deadline { get; set; }
            public string SaveLocationTitle { get; set; }
            public int? SaveLocation { get; set; }
            public int? NotPaidTransactionCount { get; set; }
            public string CountryTitleUser { get; set; }
            public string PrefixPhoneUser { get; set; }
            public int? NoteCount { get; set; }
            public string TitleCompany { get; set; }
            public int? WeightType { get; set; }
            public string WeightTypeTitle { get; set; }
            public string FullAddress { get; set; }
            public decimal? Weight { get; set; }
            public decimal? WeightFee { get; set; }
            public int? WeightFeeType { get; set; }
            public string WeightFeeTypeTitle { get; set; }
            public decimal? ProportionFactorWage { get; set; }
            public decimal? ProportionFactorWageWeight { get; set; }
            public long? UserOrderIndex { get; set; }
        }
	}
}
