﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.Order.Orders
{
    public class GetOrdersAdmin_Export
    {
        public class Inputs : BaseSearchParams
        {
            public DateTime? FromDate { get; set; }
            public DateTime? ToDate { get; set; }
            public Guid? UserId { get; set; }
            public int? Status { get; set; }
            public string Search { get; set; }
            public int? OrderType { get; set; }
            public bool? NotResolve { get; set; }
            public bool? IsLegal { get; set; }
            public long? OrderNumber { get; set; }
            public bool? DiscountStatus { get; set; }
            public decimal? MaxFinalAmount { get; set; }
            public decimal? MinFinalAmount { get; set; }
            /// <summary>
            /// لیست نوع های سفارش
            /// </summary>
            public string OrderTypeList { get; set; }
            /// <summary>
            /// روش پرداخت
            /// </summary>
            public int? PaymentMethod { get; set; }
            public TimeSpan? FromTime { get; set; }
            public TimeSpan? ToTime { get; set; }
            public bool? SeparateDateTimeFilter { get; set; }
            public int? ModuleType { get; set; }
        }

        public class Outputs
        {
            public Guid? OrderId { get; set; }
            public string Email { get; set; }
            public DateTime? ChangeDate { get; set; }
            public DateTime? SaveDate { get; set; }
            public string Family { get; set; }
            public string Name { get; set; }
            public decimal? FinalAmount { get; set; }
            public string Mobile { get; set; }
            public long? OrderNumber { get; set; }
            public string OrderTypeName { get; set; }
            public int? Status { get; set; }
            public string StatusName { get; set; }
            public Guid? UserId { get; set; }
            public DateTime? ExpireDate { get; set; }
            public decimal? FinalWageAmount { get; set; }
            public decimal? Amount { get; set; }
            public string CurrencyCode { get; set; }
            public string CurrencyTitle { get; set; }
            public decimal? CurrencyAmount { get; set; }
        }
    }
}
