﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.Order.Orders
{
    public class GetOrdersCompeletedAdmin_Export
    {
        public class Inputs : BaseSearchParams
        {
            /// <summary>
            /// از تاریخ
            /// </summary>
            public DateTime? FromDate { get; set; }
            /// <summary>
            /// تا تاریخ
            /// </summary>
            public DateTime? ToDate { get; set; }
            /// <summary>
            /// شناسه ی کاربر
            /// </summary>
            public Guid? UserId { get; set; }
            /// <summary>
            /// وضعیت سفارش
            /// </summary>
            public int? Status { get; set; }
            /// <summary>
            /// لیست وضعیت ها
            /// </summary>
            public string StatusList { get; set; }
            /// <summary>
            /// جستجوی کلی در نام و نام خانوادگی و کد ملی مشتری
            /// </summary>
            public string Search { get; set; }
            /// <summary>
            /// شماره سفارش
            /// </summary>
            public long? OrderNumber { get; set; }
            /// <summary>
            /// نوع سفارش
            /// </summary>
            public int? OrderType { get; set; }
            /// <summary>
            /// وضعیت حقوقی و یا حقیقی بودن سفارش
            /// </summary>
            public bool? IsLegal { get; set; }
            /// <summary>
            /// آیا کد تخفیف روی سفارش هست یا خیر؟
            /// </summary>
            public bool? DiscountStatus { get; set; }
            /// <summary>
            /// حداقل مبلغ سفارش
            /// </summary>
            public decimal? MaxFinalAmount { get; set; }
            /// <summary>
            /// حداکثر مبلغ سفارش
            /// </summary>
            public decimal? MinFinalAmount { get; set; }
            /// <summary>
            /// لیست نوع های سفارش
            /// </summary>
            public string OrderTypeList { get; set; }
            /// <summary>
            /// روش پرداخت
            /// </summary>
            public int? PaymentMethod { get; set; }
            public TimeSpan? FromTime { get; set; }
            public TimeSpan? ToTime { get; set; }
            public bool? SeparateDateTimeFilter { get; set; }
            public int? ModuleType { get; set; }
        }

        public class Outputs
        {
            public Guid? OrderId { get; set; }
            public string Email { get; set; }
            public DateTime? ChangeDate { get; set; }
            public DateTime? SaveDate { get; set; }
            public string Family { get; set; }
            public string Name { get; set; }
            public decimal? FinalAmount { get; set; }
            public string Mobile { get; set; }
            public long? OrderNumber { get; set; }
            public string OrderTypeName { get; set; }
            public int? Status { get; set; }
            public string StatusName { get; set; }
            public Guid? UserId { get; set; }
            public DateTime? ExpireDate { get; set; }
            public decimal? FinalWageAmount { get; set; }
            public decimal? Amount { get; set; }
            public string CurrencyCode { get; set; }
            public string CurrencyTitle { get; set; }
            public decimal? CurrencyAmount { get; set; }
        }
    }
}
