﻿using System;
using System.Collections.Generic;
using System.Security.Principal;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.Order.Scenario
{
    public class GetScenarioByAdmin
    {
        public class Inputs : BaseSearchParams
        {
            public Guid? ScenarioId { get; set; }
            public int? OrderType { get; set; }
            public Guid? ScenarioGroupId { get; set; }
            public int? ModuleType { get; set; }
            public bool? IsActive { get; set; }
            public int? PaymentMethod { get; set; }
            public int? OnlinePortal { get; set; }
            public string Search { get; set; }

        }

        public class Outputs
        {
            public Guid? ScenarioId { get; set; }
            public string Title { get; set; }
            public int? SortNumber { get; set; }
            public bool? IsCombinationOfPaymentMethods { get; set; }
            public decimal? MaximumAmountPaidToFinish { get; set; }
            public decimal? MinimumAmountPaidToStart { get; set; }
            public int? OrderType { get; set; }
            public string OrderTypeName { get; set; }
            public int? PaymentMethod { get; set; }
            public DateTime? SaveDate { get; set; }
            public bool? IsActive { get; set; }
            public string PaymentMethodName { get; set; }
            public bool? PaymentOfOrderWage { get; set; }
            public bool? PaymentWithoutOrderWage { get; set; }
            public string ScenarioGroupTitle { get; set; }
            public int? OnlinePortal { get; set; }
            public string OnlinePortalTitle { get; set; }
            public int? NextStatus { get; set; }
            public string NextStatusTitle { get; set; }
            public string Description { get; set; }
            public int? ModuleType { get; set; }
            public string ModuleTypeTitle { get; set; }
        }
    }
}
