﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction
{
    /// <summary>
    /// مدل پراسیژر تکمیل خرید با استفاده از اعتبار کیف پول
    /// </summary>
    public class Update_Transaction_Wallet_Order
    {
        public class Inputs : BaseInputModel
        {
            /// <summary>
            /// شناسه سفارش
            /// </summary>
            public Guid? OrderId { get; set; }
            /// <summary>
            /// کد تخفیف در صورت وجود
            /// </summary>
            public string Code { get; set; }
            /// <summary>
            /// مبلغ مجاز جهت پرداخت
            /// </summary>
            public decimal? AllowedAmount { get; set; }
        }

        public class Outputs
        {
            /// <summary>
            /// شماره همراه خریدار
            /// </summary>
            public string Mobile { get; set; }
            /// <summary>
            /// ایمیل خریدار
            /// </summary>
            public string Email { get; set; }
            /// <summary>
            /// شماره سفارش پرداخت شده
            /// </summary>
            public string OrderNumber { get; set; }
            /// <summary>
            /// نوع مقدار سفارش پرداخت شده
            /// </summary>
            public string ValueType { get; set; }
            /// <summary>
            /// نوع سفارش پرداخت شده
            /// </summary>
            public int? OrderType { get; set; }
            /// <summary>
            /// مقدار سود خرید با کد معرفی شرکت
            /// </summary>
            public decimal? Commission { get; set; }
            /// <summary>
            /// اگر تراکنشی به غیر از تراکنش اصلی در پراسیژر رخ داده باشد ، این فیلد با نوع آن تراکنش بر خواهد گشت 
            /// </summary>
            public int? TransactionType { get; set; }
            /// <summary>
            /// ایمیل کاربر شرکتی که در فروش این سفارش همکاری داشته است
            /// </summary>
            public string EmailCompanyUser { get; set; }
            /// <summary>
            /// شماره همراه کاربر شرکتی که در فروش این سفارش همکاری داشته است
            /// </summary>
            public string MobileCompanyUser { get; set; }
            /// <summary>
            /// مقدار سود همکاری در فروش شرکت
            /// </summary>
            public decimal? CooperRewardToman { get; set; }
            public int? NumberOfSuccessfulOrders { get; set; }
            public int? StatusOrder { get; set; }
        }
    }
}
