﻿using System;
using System.Collections.Generic;
using System.Security.Principal;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.User.Discount
{
    public class GetDiscountCode
    {
        public class Inputs : BaseSearchParams
        {
            public Guid? DiscountCodeId { get; set; }
            public int? DiscountType { get; set; }
            public bool? NeedEntered { get; set; }
            public int? OrderType { get; set; }
            public Guid? CurrencyId { get; set; }
        }

        public class Outputs
        {
            public decimal? Discount { get; set; }
            public Guid? DiscountId { get; set; }
            public string Code { get; set; }
            public Guid? CompanyId { get; set; }
            public int? DiscountType { get; set; }
            public DateTime? ExpireDate { get; set; }
            public Guid? UserId { get; set; }
            public bool? IsActive { get; set; }
            public DateTime? SaveDate { get; set; }
            public decimal? IntroducingShare { get; set; }
            public bool? ForNewUser { get; set; }
            public int? LimitUse { get; set; }
            public int? OrderPassed { get; set; }
            public decimal? MinimumPurchase { get; set; }
            public decimal? MaximumPriceDiscountPercent { get; set; }
            public bool? NeedEntered { get; set; }
            public string FullName { get; set; }
            public string CompanyName { get; set; }
            public string Title { get; set; }
            public string DiscountTypeTitle { get; set; }
            public string OrderTypeName { get; set; }
            public int? OrderType { get; set; }
            public int? MinimumPurchaseType { get; set; }
            public int? MaximumPriceDiscountPercentType { get; set; }
            public Guid? CurrencyId { get; set; }
            public string CurrencyTitle { get; set; }
            public int? AcceptLevelNumber { get; set; }
            public bool? RequiredMobile { get; set; }
            public bool? RequiredEmail { get; set; }
            public bool? RequiredNationalCardImage { get; set; }
            public bool? RequiredSelfieImage { get; set; }
            public bool? RequiredNationalCode { get; set; }
        }
    }
}
