﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Farakonesh.Models.Database.StoredProcedures.App.User.Ticket
{
    public class GetTicket
    {
        public class Inputs : BaseSearchParams
        {
            public int? Status { get; set; }
        }

        public class Outputs
        {
            /// <summary>
            /// شناسه تیکت
            /// </summary>
            public Guid? TicketId { get; set; }
            /// <summary>
            /// شماره تیکت
            /// </summary>
            public long? Number { get; set; }
            /// <summary>
            /// عنوان دپارتمان
            /// </summary>
            public string TitlePart { get; set; }
            /// <summary>
            /// درجه اهمیت
            /// </summary>
            public int? Importance { get; set; }
            /// <summary>
            /// عنوان درجه اهمیت
            /// </summary>
            public string TitleImportance { get; set; }
            /// <summary>
            /// وضعیت تیکت
            /// </summary>
            public int? Status { get; set; }
            /// <summary>
            /// عنوان وضعیت تیکت
            /// </summary>
            public string TitleStatus { get; set; }
            /// <summary>
            /// تاریخ ایجاد تیکت
            /// </summary>
            public DateTime? SaveDate { get; set; }
            /// <summary>
            /// عنوان موضوع تیکت
            /// </summary>
            public string TitleSubject { get; set; }
            /// <summary>
            /// عنوان تیکت
            /// </summary>
            public string Title { get; set; }
        }
    }
}
