﻿using Microsoft.AspNetCore.SignalR;
using System.Threading.Tasks;

namespace Farakonesh.RealTime.Hubs
{
	public class FarakoneshHub : Hub<ITicketHub>
	{

		public async Task BroadcastAsync(string message)
		{
			await Clients.All.MessageReceivedFromHub(message);
		}
		public async Task BroadcastGroupAsync(string message, string group)
		{
			await Clients.Group(group).MessageReceivedFromHub(message);
		}
		public async Task JoinGroup(string groupName)
		{
			await Groups.AddToGroupAsync(Context.ConnectionId, groupName);
		}
		public override async Task OnConnectedAsync()
		{
			await Clients.All.NewUserConnected("a new user connectd");
		}
	}
	public interface ITicketHub
	{
		Task MessageReceivedFromHub(string message);

		Task NewUserConnected(string message);
	}
}
