﻿using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Farakonesh.RealTime.Hubs;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Farakonesh.RealTime
{
	public class Startup
	{
		public Startup(IConfiguration configuration)
		{
			Configuration = configuration;
		}
		public const string corsPolicyName = "CorsPolicy";
		public IConfiguration Configuration { get; }

		public void ConfigureServices(IServiceCollection services)
		{
			services.AddControllers();
			services.AddSignalR().AddMessagePackProtocol();
			services.AddCors(o => o.AddPolicy(corsPolicyName, builder => {
				builder
                .WithOrigins(Configuration.GetValue<string>("AllowedOrigin").Split(","))
                .AllowAnyMethod()
				.AllowAnyHeader()
				.AllowCredentials();
			}));
		}

		public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
		{
			if (env.IsDevelopment())
			{
				app.UseDeveloperExceptionPage();
			}
			app.UseCors(corsPolicyName);
			app.UseRouting();

			app.UseAuthorization();

			app.UseEndpoints(endpoints =>
			{
				endpoints.MapControllers();
				endpoints.MapHub<FarakoneshHub>("/signalr");
			});
		}
	}
}
