﻿using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Farakonesh.ReportViewver.WebToken;

namespace Farakonesh.ReportViewver.Extensions
{
    public static class JwtExtensions
    {
        public static void AddJWT(this IServiceCollection services, IConfiguration configuration)
        {
            string key = configuration.GetValue<string>("JWT:Key");
            string issuer = configuration.GetValue<string>("JWT:Issuer");

            //When a request receive, this operations check the JWT and set User object
            services
                .AddAuthentication(JwtBearerDefaults.AuthenticationScheme)
            .AddJwtBearer(options =>
            {
                options.TokenValidationParameters = JWT.GetTokenValidationParameters();
                options.Events = JWT.GetJWTEvents();
            });
        }
    }
}
