﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Microsoft.Extensions.Configuration;
using Microsoft.Reporting.NETCore;
using Newtonsoft.Json;
using RestSharp;
using Farakonesh.ReportViewver.Models;
using Farakonesh.ReportViewver.Models.dbo;
using Farakonesh.ReportViewver.Models.Order;
using Farakonesh.ReportViewver.Models.User;
using Farakonesh.ReportViewver.Reports.dbo;
using Farakonesh.ReportViewver.Reports.Order;
using Farakonesh.ReportViewver.Reports.User;
using Farakonesh.ReportViewver.WebToken;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Farakonesh.Shared.Helpers;
using Microsoft.CodeAnalysis.VisualBasic.Syntax;
using Farakonesh.ReportViewver.Models.Report;
using Farakonesh.ReportViewver.Reports.Report;

namespace Farakonesh.ReportViewver.Pages
{
    public class IndexModel : PageModel
    {
        private const string renderFormatPDF = "PDF";
        private const string renderFormatHTML5 = "HTML5";
        private const string renderFormatWORDOPENXML = "WORDOPENXML";
        private const string renderFormatEXCELOPENXML = "EXCELOPENXML";
        private const string extensionPDF = "pdf";
        private const string extensionEXCEL = "xlsx";
        private const string extensionHTML5 = "html";
        private const string extensionDOCX = "docx";
        private const string mimeTypePDF = "application/pdf";
        private const string mimeTypeHTML5 = "text/html";
        private const string mimeTypeDOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        private const string mimeTypeEXCEL = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        private readonly IHttpContextAccessor _httpContext;
        [BindProperty]
        public string Message { get; set; }
        [BindProperty]
        public string BaseApi { get; set; }
        [BindProperty]
        public string ReportType { get; set; }
        [BindProperty]
        public GetUserModel User { get; set; }
        [BindProperty]
        public GetSettingLogoTitleUrlModel Setting { get; set; }
        [BindProperty]
        public string AccessToken { get; set; }
        [BindProperty]
        public string EXT { get; set; }
        [FromForm] public int? PageSize { get; set; } = 100000;

        private readonly IConfiguration _configuration;
        public IndexModel(IConfiguration configuration, IHttpContextAccessor httpContext)
        {
            _configuration = configuration;
            _httpContext = httpContext;
        }
        private string getStringParameter(string key)
        {
            if (Request.Query.ContainsKey(key) && !string.IsNullOrWhiteSpace(Request.Query[key])
             && Request.Query[key].ToString().ToLower() != "undefined" && Request.Query[key].ToString().ToLower() != "null")
            {
                return Request.Query[key].ToString();
            }
            return "";
        }
        private int? getIntegerParameter(string key)
        {
            if (Request.Query.ContainsKey(key) && !string.IsNullOrWhiteSpace(Request.Query[key])
                && Request.Query[key].ToString().ToLower() != "undefined" && Request.Query[key].ToString().ToLower() != "null")
            {
                return Convert.ToInt32(Request.Query[key]);
            }
            return null;
        }
        private bool? getBooleanParameter(string key)
        {
            if (Request.Query.ContainsKey(key) && !string.IsNullOrWhiteSpace(Request.Query[key])
                && Request.Query[key].ToString().ToLower() != "undefined" && Request.Query[key].ToString().ToLower() != "null")
            {
                return Convert.ToBoolean(Request.Query[key]);
            }
            return null;
        }
        private bool validateParameter()
        {
            if (Request.Query == null || Request.Query.Count == 0 || getStringParameter("key") == null
                || string.IsNullOrWhiteSpace(JWT.getUserModel().UserId))
            {
                Message = "متاسفانه به این برگه دسترسی ندارید";
                return false;
            }
            else if (getStringParameter("type") == null)
            {
                Message = "نوع گزارش مشخص نشده است";
                return false;
            }

            return true;
        }
        private async Task setSessionBasicInfo()
        {
            _httpContext.HttpContext.Session.Clear();
            if (validateParameter())
            {
                this.ReportType = getStringParameter("type");
                _httpContext.HttpContext.Session.SetString("type", this.ReportType);
                AccessToken = JWT.getUserModel().AccessToken;
                _httpContext.HttpContext.Session.SetString("accessToken", JWT.getUserModel().AccessToken);
                this.EXT = getStringParameter("ext");
                _httpContext.HttpContext.Session.SetString("ext", this.EXT);
                this.BaseApi = _configuration.GetSection("BaseApi").Get<string>();
                _httpContext.HttpContext.Session.SetString("baseApi", this.BaseApi);
                if (getIntegerParameter("size") != null)
                {
                    this.PageSize = getIntegerParameter("size");
                }
                var settingResponse = await executeAsyncGet<BasicResponse<GetSettingLogoTitleUrlModel>>(this.BaseApi + "Settings/GetBasic", null);
                if (!settingResponse.IsSuccessful)
                {
                    this.Message = "خطا در دریافت تنظیمات برنامه";
                }
                else
                {
                    this.Setting = settingResponse.Data.data;
                    _httpContext.HttpContext.Session.SetString("setting", JsonConvert.SerializeObject(this.Setting));
                }
                var userResponse = await executeAsync<BasicResponse<GetUserModel>>(this.BaseApi + "User/Get",
                       new { }, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });
                if (!userResponse.IsSuccessful)
                {
                    this.Message = "خطا در دریافت اطلاعات کاربر";
                }
                else
                {
                    this.User = userResponse.Data.data;
                    _httpContext.HttpContext.Session.SetString("user", JsonConvert.SerializeObject(this.User));
                }
            }


        }




        public async Task<IActionResult> OnGet()
        {
            await setSessionBasicInfo();
            switch (this.ReportType)
            {
                case "ordersAdmin":
                    setSessionGetOrdersParameter();
                    break;
                case "ordersCompeletedAdmin":
                    setSessionGetOrdersCompeletedParameter();
                    break;
                case "ordersTransactionAdmin":
                    setSessionGetOrdersTransActionParameter();
                    break;
                case "cashAdmin":
                    setSessionGetCashParameter();
                    break;
                case "userList":
                    setSessionGetUserListParameter();
                    break;
                case "userReport":
                    setSessionGetUserReportParameter();
                    break;
                case "userCategoryReport":
                    setSessionGetUserCategoryReportParameter();
                    break;
                case "invoice":
                    setSessionInvoiceParameter();
                    break;
                case "accountService":
                    setSessionGetAccountListParameter();
                    break;
                case "ticket":
                    setSessionGetReportTicketParameter();
                    break;
                default:
                    break;
            }

            switch (this.EXT)
            {
                case "pdf":
                    return await this.OnPostGetPDF();

                case "docx":
                    return await this.OnPostGetDOCX();

                case "xlsx":
                    return await this.OnPostGetXLSX();

                case "html":
                    return await this.OnPostGetHTML();

                default:
                    return Page();
            }

        }

        public async Task<IActionResult> OnPostGetPDF()
        {
            string reportType = _httpContext.HttpContext.Session.GetString("type");

            switch (reportType)
            {
                case "ordersAdmin":
                    return await prepareReportGetOrdersAdmin(renderFormatPDF, extensionPDF, mimeTypePDF);
                case "ordersCompeletedAdmin":
                    return await prepareReportGetOrdersCompeletedAdmin(renderFormatPDF, extensionPDF, mimeTypePDF);
                case "ordersTransactionAdmin":
                    return await prepareReportGetOrdersTransActionAdmin(renderFormatPDF, extensionPDF, mimeTypePDF);
                case "cashAdmin":
                    return await prepareReportGetCashAdmin(renderFormatPDF, extensionPDF, mimeTypePDF);
                case "userList":
                    return await prepareReportGetUserList(renderFormatPDF, extensionPDF, mimeTypePDF);
                case "userReport":
                    return await prepareReportGetUserReport(renderFormatPDF, extensionPDF, mimeTypePDF);
                case "userCategoryReport":
                    return await prepareReportGetUserCategoryReport(renderFormatPDF, extensionPDF, mimeTypePDF);
                case "invoice":
                    return await prepareInvoice(renderFormatPDF, extensionPDF, mimeTypePDF);
                case "accountService":
                    return await prepareReportGetAccountServiceList(renderFormatPDF, extensionPDF, mimeTypePDF);
                case "ticket":
                    return await prepareReportGetTicketList(renderFormatPDF, extensionPDF, mimeTypePDF);
                default:
                    return null;
            }

        }
        public async Task<IActionResult> OnPostGetHTML()
        {

            string reportType = _httpContext.HttpContext.Session.GetString("type");

            switch (reportType)
            {
                case "ordersAdmin":
                    return await prepareReportGetOrdersAdmin(renderFormatHTML5, extensionHTML5, mimeTypeHTML5);
                case "ordersCompeletedAdmin":
                    return await prepareReportGetOrdersCompeletedAdmin(renderFormatHTML5, extensionHTML5, mimeTypeHTML5);
                case "ordersTransactionAdmin":
                    return await prepareReportGetOrdersTransActionAdmin(renderFormatHTML5, extensionHTML5, mimeTypeHTML5);
                case "cashAdmin":
                    return await prepareReportGetCashAdmin(renderFormatHTML5, extensionHTML5, mimeTypeHTML5);
                case "userList":
                    return await prepareReportGetUserList(renderFormatHTML5, extensionHTML5, mimeTypeHTML5);
                case "userReport":
                    return await prepareReportGetUserReport(renderFormatHTML5, extensionHTML5, mimeTypeHTML5);
                case "userCategoryReport":
                    return await prepareReportGetUserCategoryReport(renderFormatHTML5, extensionHTML5, mimeTypeHTML5);
                case "accountService":
                    return await prepareReportGetAccountServiceList(renderFormatHTML5, extensionHTML5, mimeTypeHTML5);
                case "ticket":
                    return await prepareReportGetTicketList(renderFormatHTML5, extensionHTML5, mimeTypeHTML5);
                default:
                    return null;
            }
        }
        public async Task<IActionResult> OnPostGetDOCX()
        {
            string reportType = _httpContext.HttpContext.Session.GetString("type");

            switch (reportType)
            {
                case "ordersAdmin":
                    return await prepareReportGetOrdersAdmin(renderFormatWORDOPENXML, extensionDOCX, mimeTypeDOCX);
                case "ordersCompeletedAdmin":
                    return await prepareReportGetOrdersCompeletedAdmin(renderFormatWORDOPENXML, extensionDOCX, mimeTypeDOCX);
                case "ordersTransactionAdmin":
                    return await prepareReportGetOrdersTransActionAdmin(renderFormatWORDOPENXML, extensionDOCX, mimeTypeDOCX);
                case "cashAdmin":
                    return await prepareReportGetCashAdmin(renderFormatWORDOPENXML, extensionDOCX, mimeTypeDOCX);
                case "userList":
                    return await prepareReportGetUserList(renderFormatWORDOPENXML, extensionDOCX, mimeTypeDOCX);
                case "userReport":
                    return await prepareReportGetUserReport(renderFormatWORDOPENXML, extensionDOCX, mimeTypeDOCX);
                case "userCategoryReport":
                    return await prepareReportGetUserCategoryReport(renderFormatWORDOPENXML, extensionDOCX, mimeTypeDOCX);
                case "accountService":
                    return await prepareReportGetAccountServiceList(renderFormatWORDOPENXML, extensionDOCX, mimeTypeDOCX);
                case "ticket":
                    return await prepareReportGetTicketList(renderFormatWORDOPENXML, extensionDOCX, mimeTypeDOCX);
                default:
                    return null;
            }

        }
        public async Task<IActionResult> OnPostGetXLSX()
        {
            string reportType = _httpContext.HttpContext.Session.GetString("type");

            switch (reportType)
            {
                case "ordersAdmin":
                    return await prepareReportGetOrdersAdmin(renderFormatEXCELOPENXML, extensionEXCEL, mimeTypeEXCEL);
                case "ordersCompeletedAdmin":
                    return await prepareReportGetOrdersCompeletedAdmin(renderFormatEXCELOPENXML, extensionEXCEL, mimeTypeEXCEL);
                case "ordersTransactionAdmin":
                    return await prepareReportGetOrdersTransActionAdmin(renderFormatEXCELOPENXML, extensionEXCEL, mimeTypeEXCEL);
                case "cashAdmin":
                    return await prepareReportGetCashAdmin(renderFormatEXCELOPENXML, extensionEXCEL, mimeTypeEXCEL);
                case "userList":
                    return await prepareReportGetUserList(renderFormatEXCELOPENXML, extensionEXCEL, mimeTypeEXCEL);
                case "userReport":
                    return await prepareReportGetUserReport(renderFormatEXCELOPENXML, extensionEXCEL, mimeTypeEXCEL);
                case "userCategoryReport":
                    return await prepareReportGetUserCategoryReport(renderFormatEXCELOPENXML, extensionEXCEL, mimeTypeEXCEL);
                case "accountService":
                    return await prepareReportGetAccountServiceList(renderFormatEXCELOPENXML, extensionEXCEL, mimeTypeEXCEL);
                case "ticket":
                    return await prepareReportGetTicketList(renderFormatEXCELOPENXML, extensionEXCEL, mimeTypeEXCEL);
                default:
                    return null;
            }
        }

        #region چاپ فاکتور

        private void setSessionInvoiceParameter()
        {
            var parameters = new GetOrderByIdAdminParams()
            {
                orderId = getStringParameter("orderId")
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }

        private async Task<IActionResult> prepareInvoice(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));
            var paramtersQueryString = JsonConvert.DeserializeObject<GetOrderByIdAdminParams>(_httpContext.HttpContext.Session.GetString("parameters"));
            var response = await executeAsync<BasicResponse<GetOrderByIdAdminModel>>(this.BaseApi + "Order/Print",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });
            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات فاکتور";
                return null;
            }
            var model = new List<InvoiceModel>();
            model.Add(new InvoiceModel
            {
                amount = response.Data.data.amount,
                currencyAmount = response.Data.data.currencyAmount,
                currencyTitle = response.Data.data.currencyTitle,
                orderNumber = response.Data.data.orderNumber,
                orderTypeName = response.Data.data.orderTypeName,
                statusName = response.Data.data.statusName
            });

            Invoice.Load(report, model.ToArray(), getParametersInvoice(response.Data.data));
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "print_invoice_" + DateTime.Now + "." + extension);
        }
        private ReportParameter[] getParametersInvoice(GetOrderByIdAdminModel model)
        {
            var parameters = new[] { new ReportParameter("OperatorName", this.User.name + " " + this.User.family)
            , new ReportParameter("Logo", this.Setting.logoAddress)
            ,new ReportParameter("InvoiceDate",model.saveDate),new ReportParameter("InvoiceNumber",model.orderNumber.ToString()),
            new ReportParameter("SellerFullName",!string.IsNullOrWhiteSpace(this.Setting.companyName)?this.Setting.companyName:"")
            ,new ReportParameter("SellerWebsite",this.Setting.siteUrlRoot)
            ,new ReportParameter("SellerTel",this.Setting.telOfCompany)
            ,new ReportParameter("SellerRegistrationNumber",this.Setting.companyRegistrationNumber)
            ,new ReportParameter("SellerNationalNumber",this.Setting.nationalCompanyNumber)
            ,new ReportParameter("SellerAddress",!string.IsNullOrWhiteSpace(this.Setting.addressOfCompany)?this.Setting.addressOfCompany:""),
            new ReportParameter("BuyerFullName",model.name+" "+model.family),
            new ReportParameter("BuyerNationalCode",model.nationalCode),
            new ReportParameter("BuyerMobile",model.mobile),new ReportParameter("BuyerEmail",!string.IsNullOrWhiteSpace(model.email)?model.email:"")
            ,new ReportParameter("Stamp",this.Setting.stampOfCompany)
            ,new ReportParameter("SellerZipCode",this.Setting.companyZipCode)
            ,new ReportParameter("FinalWage",moneyFormat(model.finalWageAmount))
            ,new ReportParameter("FinalAmount",moneyFormat(model.finalAmount))
            ,new ReportParameter("IsLegal",model.isLegal == true?"True":"False")
            ,new ReportParameter("NationalId",model.nationalId)
            ,new ReportParameter("RegistrationNumber",model.registrationNumber)
            ,new ReportParameter("NameOfCompany",model.nameOfCompany)
            ,new ReportParameter("AddressOfCompany",model.addressOfCompany)
            ,new ReportParameter("TelOfCompany",model.telOfCompany)};
            return parameters;
        }

        #endregion چاپ فاکتور

        #region گزارش لیست سفارش ها

        private void setSessionGetOrdersParameter()
        {
            var parameters = new GetOrdersAdminParams()
            {
                fromDate = getStringParameter("fromDate"),
                toDate = getStringParameter("toDate"),
                userId = getStringParameter("userId"),
                status = getStringParameter("status"),
                search = getStringParameter("search"),
                orderType = getStringParameter("orderType"),
                notResolve = getStringParameter("notResolve"),
                isLegal = getStringParameter("isLegal"),
                discountStatus = getStringParameter("discountStatus"),
                maxFinalAmount = getStringParameter("maxFinalAmount"),
                minFinalAmount = getStringParameter("minFinalAmount"),
                orderNumber = getStringParameter("orderNumber"),
                paymentMethod = getStringParameter("paymentMethod"),
                orderTypeList = getStringParameter("orderTypeList"),
                fromTime = getStringParameter("fromTime"),
                toTime = getStringParameter("toTime"),
                separateDateTimeFilter = getBooleanParameter("separateDateTimeFilter"),
                moduleType = getStringParameter("moduleType"),
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }

        private async Task<IActionResult> prepareReportGetOrdersAdmin(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));
            var paramtersQueryString = JsonConvert.DeserializeObject<GetOrdersAdminParams>(_httpContext.HttpContext.Session.GetString("parameters"));
            paramtersQueryString.pageSize = this.PageSize;
            var response = await executeAsync<BasicResponse<List<GetOrdersAdminModel>>>(this.BaseApi + "Order/GetAllByAdminPrint",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });
            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات گزارش";
                return null;
            }
            ReportGetOrdersAdmin.Load(report, response.Data.data.ToArray(), getParameters());
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "report_orders_" + DateTime.Now + "." + extension);
        }
        #endregion گزارش لیست سفارش ها

        #region گزارش لیست سفارش های تکمیل شده

        private void setSessionGetOrdersCompeletedParameter()
        {
            var parameters = new GetOrdersCompeletedAdminParams()
            {
                fromDate = getStringParameter("fromDate"),
                toDate = getStringParameter("toDate"),
                userId = getStringParameter("userId"),
                status = getStringParameter("status"),
                search = getStringParameter("search"),
                orderType = getStringParameter("orderType"),
                statusList = getStringParameter("statusList"),
                isLegal = getStringParameter("isLegal"),
                discountStatus = getStringParameter("discountStatus"),
                maxFinalAmount = getStringParameter("maxFinalAmount"),
                minFinalAmount = getStringParameter("minFinalAmount"),
                orderNumber = getStringParameter("orderNumber"),
                paymentMethod = getStringParameter("paymentMethod"),
                orderTypeList = getStringParameter("orderTypeList"),
                fromTime = getStringParameter("fromTime"),
                toTime = getStringParameter("toTime"),
                separateDateTimeFilter = getBooleanParameter("separateDateTimeFilter"),
                moduleType = getStringParameter("moduleType"),
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }

        private async Task<IActionResult> prepareReportGetOrdersCompeletedAdmin(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));
            var paramtersQueryString = JsonConvert.DeserializeObject<GetOrdersCompeletedAdminParams>(_httpContext.HttpContext.Session.GetString("parameters"));
            paramtersQueryString.pageSize = this.PageSize;
            var response = await executeAsync<BasicResponse<List<GetOrdersCompeletedAdminModel>>>(this.BaseApi + "Order/GetAllByAdminCompeletedPrint",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });
            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات گزارش";
                return null;
            }
            ReportGetOrdersAdminCompeleted.Load(report, response.Data.data.ToArray(), getParameters());
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "report_orders_compeleted_" + DateTime.Now + "." + extension);
        }
        #endregion گزارش لیست سفارش های تکمیل شده

        #region گزارش لیست تراکنش های کاربر و سفارش
        private void setSessionGetOrdersTransActionParameter()
        {
            var parameters = new GetOrdersTrasnActionAdminParams()
            {
                fromDate = getStringParameter("fromDate"),
                toDate = getStringParameter("toDate"),
                userId = getStringParameter("userId"),
                orderId = getStringParameter("orderId"),
                search = getStringParameter("search"),
                transactionType = getStringParameter("transactionType"),
                transactionTypeList = getStringParameter("transactionTypeList"),
                isPaid = getBooleanParameter("isPaid"),
                onlinePortal = getIntegerParameter("onlinePortal")
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }

        private async Task<IActionResult> prepareReportGetOrdersTransActionAdmin(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));
            var paramtersQueryString = JsonConvert.DeserializeObject<GetOrdersTrasnActionAdminParams>(_httpContext.HttpContext.Session.GetString("parameters"));
            paramtersQueryString.pageSize = this.PageSize;
            var response = await executeAsync<BasicResponse<List<GetOrdersTransActionAdminModel>>>(this.BaseApi + "Transactions/GetAllByAdmin",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });
            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات گزارش";
                return null;
            }
            ReportGetOrdersTransActionAdmin.Load(report, response.Data.data.ToArray(), getParameters());
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "report_orders_transaction_" + DateTime.Now + "." + extension);
        }
        #endregion گزارش لیست تراکنش های کاربر و سفارش

        #region سرویس ها و زیرساخت ها
        private void setSessionGetAccountListParameter()
        {
            var parameters = new AccountServiceParams()
            {
                accountServiceId = getStringParameter("accountServiceId")
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }
        private async Task<IActionResult> prepareReportGetAccountServiceList(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));
            var paramtersQueryString = JsonConvert.DeserializeObject<AccountServiceParams>(_httpContext.HttpContext.Session.GetString("parameters"));
            var response = await executeAsync<BasicResponse<List<AccountServiceModel>>>(this.BaseApi + "AccountService/Get",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });
            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات گزارش";
                return null;
            }

            if (response.Data.data != null && response.Data.data.Count > 0)
            {
                foreach (var item in response.Data.data)
                {
                    var monthNumber = item.paymentPeriod.convertDayToMonth();
                    if (item.price > 0)
                    {
                        if (item.paymentPeriod <= 31)
                        {
                            item.priceByMonth = item.price;
                        }
                        else
                        {
                            if (monthNumber > 0)
                                item.priceByMonth = (item.price / monthNumber);
                            else
                                item.priceByMonth = item.price;
                        }
                    }

                }
            }
            AccountService.Load(report, response.Data.data.ToArray(), getParameters());
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "report_account_service_" + DateTime.Now + "." + extension);
        }
        #endregion سرویس ها و زیرساخت ها

        #region گزارش تیکت ها
        private void setSessionGetReportTicketParameter()
        {
            var parameters = new GetTicketParams()
            {
                fromDate = getStringParameter("fromDate"),
                toDate = getStringParameter("toDate"),
                fromTime = getStringParameter("fromTime"),
                toTime = getStringParameter("toTime")
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }
        private async Task<IActionResult> prepareReportGetTicketList(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));
            var paramtersQueryString = JsonConvert.DeserializeObject<GetTicketParams>(_httpContext.HttpContext.Session.GetString("parameters"));
            var response = await executeAsync<BasicResponse<GetTicketModel>>(this.BaseApi + "Ticket/GetTicketReportByAdmin",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });
            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات گزارش";
                return null;
            }
            var ticketModel = new List<GetTicketModel>();
            if (response.Data.data != null)
            {
                ticketModel.Add(response.Data.data);
            }
            ReportTicket.Load(report, ticketModel.ToArray(), getParameters());
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "report_ticket_" + DateTime.Now + "." + extension);
        }
        #endregion گزارش تیکت ها

        #region گزارش دسته بندی کاربران
        private void setSessionGetUserCategoryReportParameter()
        {
            var parameters = new GetUserCategoryReportParams()
            {
                userId = getStringParameter("userId"),
                fromDate = getStringParameter("fromDate"),
                toDate = getStringParameter("mobile"),
                search = getStringParameter("search"),
                fromCountTransaction = getStringParameter("fromCountTransaction"),
                toCountTransaction = getStringParameter("toCountTransaction"),
                fromPrice = getStringParameter("fromPrice"),
                toPrice = getStringParameter("toPrice"),
                rFMCategoryDefinitionsId = getStringParameter("rFMCategoryDefinitionsId"),
                unknown = getBooleanParameter("unknown"),
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }
        private async Task<IActionResult> prepareReportGetUserCategoryReport(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));

            var paramtersQueryString = JsonConvert.DeserializeObject<GetUserCategoryReportParams>(_httpContext.HttpContext.Session.GetString("parameters"));

            paramtersQueryString.pageSize = this.PageSize;

            var response = await executeAsync<BasicResponse<List<GetUserCategoryReportModel>>>(this.BaseApi + "Rfm/GetUserCategory",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });

            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات گزارش";
                return null;
            }

            ReportGetUserCategoryReport.Load(report, response.Data.data.ToArray(), getParameters());
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "report_userCategoryReport_" + DateTime.Now + "." + extension);
        }
        #endregion گزارش دسته بندی کاربران
        #region گزارش مالی/فعالیت کاربران

        private void setSessionGetUserReportParameter()
        {
            var parameters = new GetUserReportParams()
            {
                userId = getStringParameter("userId"),
                fromDate = getStringParameter("fromDate"),
                toDate = getStringParameter("mobile"),
                search = getStringParameter("search"),
                isPaid = getBooleanParameter("isPaid")
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }



        private async Task<IActionResult> prepareReportGetUserReport(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));

            var paramtersQueryString = JsonConvert.DeserializeObject<GetUserReportParams>(_httpContext.HttpContext.Session.GetString("parameters"));

            paramtersQueryString.pageSize = this.PageSize;

            var response = await executeAsync<BasicResponse<List<GetUserReportModel>>>(this.BaseApi + "UserReport/GetUserReport",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });

            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات گزارش";
                return null;
            }

            ReportGetUserReport.Load(report, response.Data.data.ToArray(), getParameters());
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "report_userReport_" + DateTime.Now + "." + extension);
        }
        #endregion گزارش مالی/فعالیت کاربران

        #region گزارش لیست کاربران

        private void setSessionGetUserListParameter()
        {
            var parameters = new GetUserParams()
            {
                fromLevelNumber = getStringParameter("fromLevelNumber"),
                isActive = getStringParameter("isActive"),
                mobile = getStringParameter("mobile"),
                nationalCode = getStringParameter("nationalCode"),
                search = getStringParameter("search"),
                toLevelNumber = getStringParameter("toLevelNumber"),
                fromDateBirthDate = getStringParameter("fromDateBirthDate"),
                toDateBirthDate = getStringParameter("toDateBirthDate"),
                isCalled = getStringParameter("isCalled"),
                fromDateRegister = getStringParameter("fromDateRegister"),
                toDateRegister = getStringParameter("toDateRegister"),
                countryId = getStringParameter("countryId"),
                fromTimeRegister = getStringParameter("fromTimeRegister"),
                toTimeRegister = getStringParameter("toTimeRegister"),
                separateDateTimeFilter = getBooleanParameter("separateDateTimeFilter"),
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }

        private async Task<IActionResult> prepareReportGetUserList(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));

            var paramtersQueryString = JsonConvert.DeserializeObject<GetUserParams>(_httpContext.HttpContext.Session.GetString("parameters"));

            paramtersQueryString.pageSize = this.PageSize;

            var response = await executeAsync<BasicResponse<List<GetUserListModel>>>(this.BaseApi + "User/GetList",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });

            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات گزارش";
                return null;
            }

            ReportGetUserList.Load(report, response.Data.data.ToArray(), getParameters());
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "report_users_" + DateTime.Now + "." + extension);
        }
        #endregion گزارش لیست کاربران

        #region گزارش لیست تسویه حساب ها

        private void setSessionGetCashParameter()
        {
            var parameters = new GetCashAdminParams()
            {
                search = getStringParameter("search"),
            };

            _httpContext.HttpContext.Session.SetString("parameters", JsonConvert.SerializeObject(parameters));
        }

        private async Task<IActionResult> prepareReportGetCashAdmin(string renderFormat, string extension, string mimeType)
        {
            using var report = new LocalReport();
            this.AccessToken = _httpContext.HttpContext.Session.GetString("accessToken");
            this.BaseApi = _httpContext.HttpContext.Session.GetString("baseApi");
            this.Setting = JsonConvert.DeserializeObject<GetSettingLogoTitleUrlModel>(_httpContext.HttpContext.Session.GetString("setting"));
            this.User = JsonConvert.DeserializeObject<GetUserModel>(_httpContext.HttpContext.Session.GetString("user"));
            var paramtersQueryString = JsonConvert.DeserializeObject<GetCashAdminParams>(_httpContext.HttpContext.Session.GetString("parameters"));
            paramtersQueryString.pageSize = this.PageSize;
            var response = await executeAsync<BasicResponse<List<GetCashAdminModel>>>(this.BaseApi + "Cash/GetAllByAdmin",
                paramtersQueryString, Method.Put, new Dictionary<string, string> { { "Authorization", AccessToken } });
            if (!response.IsSuccessful)
            {
                this.Message = "خطا در دریافت اطلاعات گزارش";
                return null;
            }
            ReportGetCashAdmin.Load(report, response.Data.data.ToArray(), getParameters());
            var pdf = report.Render(renderFormat);
            return File(pdf, mimeType, "report_cash_" + DateTime.Now + "." + extension);
        }
        #endregion گزارش لیست تسویه حساب ها
        private ReportParameter[] getParameters()
        {
            var parameters = new[] { new ReportParameter("OperatorName", this.User.name + " " + this.User.family), new ReportParameter("Logo", this.Setting.logoAddress) };
            return parameters;
        }

        public async Task<RestResponse<T>> executeAsync<T>(string action, object body
     , Method method, Dictionary<string, string> headers = null)
        {
            RestClient requestClient = new RestClient();
            RestRequest request = new RestRequest(action, method);
            request.AddHeader("Accept", "application/json");
            request.AddBody(body, "application/json");

            if (headers != null)
            {
                foreach (var item in headers)
                {
                    request.AddHeader(item.Key, item.Value);
                }
            }

            var response = await requestClient.ExecuteAsync<T>(request);

            return response;
        }

        public async Task<RestResponse<T>> executeAsyncGet<T>(string action, Dictionary<string, string> parameters
     , Dictionary<string, string> headers = null)
        {
            RestClient requestClient = new RestClient();
            RestRequest request = new RestRequest(action, Method.Get);
            request.AddHeader("Accept", "application/json");
            if (parameters != null && parameters.Count > 0)
            {
                foreach (var item in parameters)
                {
                    request.AddParameter(item.Key, item.Value);
                }
            }

            if (headers != null)
            {
                foreach (var item in headers)
                {
                    request.AddHeader(item.Key, item.Value);
                }
            }

            var response = await requestClient.ExecuteAsync<T>(request);
            return response;
        }

        public static string moneyFormat(string price)
        {
            if (price == null || price == "")
            {
                return null;
            }
            var priceLong = Convert.ToInt64(price);
            return Int64.Parse(priceLong.ToString().Replace(",", "")).ToString("#,0").ToString();
        }
        public static string moneyFormat(decimal price)
        {
            var priceLong = Convert.ToInt64(price);
            return Int64.Parse(priceLong.ToString().Replace(",", "")).ToString("#,0").ToString();
        }
        public static string moneyFormat(decimal? price)
        {
            if (price == null)
            {
                return null;
            }
            var priceLong = Convert.ToInt64(price);
            return Int64.Parse(priceLong.ToString().Replace(",", "")).ToString("#,0").ToString();
        }
        public static string moneyFormat(double? price)
        {
            if (price == null)
            {
                return null;
            }
            return Int64.Parse(price.Value.ToString().Replace(",", "")).ToString("#,0").ToString();
        }
        public static string moneyFormat(double price)
        {

            return Int64.Parse(price.ToString().Replace(",", "")).ToString("#,0");
        }
    }
}
