﻿using System.Linq;
using System.Reflection;
using Microsoft.Reporting.NETCore;
using Farakonesh.ReportViewver.Models.dbo;
using Farakonesh.ReportViewver.Models.Order;

namespace Farakonesh.ReportViewver.Reports.dbo
{
    public class AccountService
    {
       public static void Load(LocalReport report, AccountServiceModel[] data, ReportParameter[] parameters)
        {
            report.EnableExternalImages = true;
            using var rs = Assembly.GetExecutingAssembly().GetManifestResourceStream("Farakonesh.ReportViewver.Reports.dbo.accountService.rdlc");
            report.LoadReportDefinition(rs);
            report.DataSources.Add(new ReportDataSource("DataSet", data));
            report.SetParameters(parameters);
        }
    }
}
