﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Farakonesh.Shared.Enums
{
    /// <summary>
    /// وضعیت سفارش
    /// </summary>
    public enum OrderStatus
    {
        [Description("پیش فاکتور")]
        Invoice = 181,
        [Description("پرداخت شده")]
        Paid = 182,
        [Description("در حال بررسی سند واریزی")]
        CheckingDepositDocument = 183,
        [Description("تایید شده")]
        Accepted = 184,
        [Description("در حال انجام")]
        Doing = 185,
        [Description("انجام شده")]
        Done = 186,
        [Description("لغو شده")]
        Canceled = 187,
        [Description("در انتظار ارسال فیش پرداختی")]
        AwaitingPaymentReceipt = 188,
        [Description("تایید نشده")]
        NotConfirmed = 189,
        [Description("تسویه شده")]
        Cleared = 195,
        [Description("در انتظار عودت وجه")]
        WaitingRefund = 190,
        [Description("درحال بررسی")]
        Pending = 191,
        [Description("در انتظار پرداخت وجه باقی مانده")]
        AwaitingPaymentRemainingAmount = 192,
        [Description("در انتظار اقدام کارشناسان")]
        AwaitingExpertAction = 193,
        [Description("در انتظار تسویه حساب")]
        AwaitingSettlement = 194,
        [Description("تسویه شده")]
        Settled = 195,
        [Description("در انتظار تعیین وقت")]
        AwaitingAppointment = 196,
        [Description("در انتظار ارسال حساب")]
        WaitingInvoiceSent = 197,

    }
}
