﻿using System;
using System.Globalization;

namespace Farakonesh.Shared.Exceptions
{
    /// <summary>
    /// داده ای از دیتابیس یا از وب سرویس خارجی برگشت داده نشده است
    /// </summary>
    public class NoDataFoundException : Exception
    {
        public NoDataFoundException() : base()
        {
        }

        public NoDataFoundException(string message) : base(message + "::483")
        {
        }

        public NoDataFoundException(string message, params object[] args)
            : base(string.Format(CultureInfo.CurrentCulture, message, args))
        {
        }
    }
}
