﻿using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using PhoneNumbers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Farakonesh.Shared.Helpers
{
    public static class ConvertHelper
    {
        public static string SetValidAddress(this string address, string countryCallingCodeWithPlus, VerifyType type)
        {
            address = address.Trim();
            if (type == VerifyType.Email)
            {
                if (address.IsValidEmail())
                {
                    return address;
                }
                throw new RequestException("ایمیل وارد شده معتبر نمی باشد");
            }
            else if (type == VerifyType.Mobile)
            {
                var newAddress = address.ExtractNationalNumber(countryCallingCodeWithPlus);
                if(!string.IsNullOrWhiteSpace(newAddress))
                {
                    return newAddress;
                }
                else
                {
                    throw new RequestException("شماره همراه وارد شده معتبر نمی باشد");
                }
            }
            else if (type == VerifyType.Phone)
            {
                return address;
            }
            return null;
        }
        public static string ExtractNationalNumber(this string input, string countryCallingCodeWithPlus)
        {
            try
            {
                var phoneUtil = PhoneNumberUtil.GetInstance();

                string inputDigits = new string(input.Where(char.IsDigit).ToArray());
                string countryCallingCode = new string(countryCallingCodeWithPlus.Where(char.IsDigit).ToArray());
                if (inputDigits.StartsWith("00"))
                {
                    inputDigits = inputDigits.Substring(2);
                }

                if (inputDigits.StartsWith(countryCallingCode))
                {
                    inputDigits = inputDigits.Substring(countryCallingCode.Length);
                }

                string fullNumber = "+" + countryCallingCode + inputDigits;

                var parsedNumber = phoneUtil.Parse(fullNumber, "ZZ");

                if (phoneUtil.IsValidNumber(parsedNumber))
                {
                    return parsedNumber.NationalNumber.ToString();
                }
            }
            catch (NumberParseException)
            {
                return null;
            }
            return null;
        }

        public static string NormalizePhoneNumberForLogin(this string input)
        {
            try
            {
                var phoneUtil = PhoneNumberUtil.GetInstance();
                string digitsOnly = new string(input.Where(char.IsDigit).ToArray());

                if (digitsOnly.StartsWith("00"))
                {
                    digitsOnly = "+" + digitsOnly.Substring(2);
                }
                else if (input.Trim().StartsWith("+"))
                {
                    digitsOnly = "+" + digitsOnly;
                }
                else if (digitsOnly.Length == 11 && digitsOnly.StartsWith("0"))
                {
                    digitsOnly = "+98" + digitsOnly.Substring(1);
                }
                else if (digitsOnly.Length == 10)
                {
                    digitsOnly = "+98" + digitsOnly;
                }
                else if (digitsOnly.Length > 11)
                {
                    digitsOnly = "+" + digitsOnly;
                }
                else
                {
                    throw new RequestException("نام کاربری وارد شده قابل تشخیص نیست ، لطفا از صحت آن اطمینان حاصل کنید");
                }

                var parsedNumber = phoneUtil.Parse(digitsOnly, "ZZ");

                if (phoneUtil.IsValidNumber(parsedNumber))
                {
                    return parsedNumber.NationalNumber.ToString();
                }
            }
            catch (NumberParseException)
            {
                throw new RequestException("نام کاربری وارد شده معتبر نمی باشد");
            }
            throw new RequestException("نام کاربری وارد شده معتبر نمی باشد");
        }

        public static string ExtractCountryCallingCode(this string input)
        {
            try
            {
                if (string.IsNullOrWhiteSpace(input))
                    throw new RequestException("شماره وارد شده معتبر نمی باشد");

                var phoneUtil = PhoneNumberUtil.GetInstance();

                string digitsOnly = new string(input.Where(char.IsDigit).ToArray());

                if (digitsOnly.StartsWith("00"))
                {
                    digitsOnly = "+" + digitsOnly.Substring(2);
                }
                else if (!digitsOnly.StartsWith("+"))
                {
                    digitsOnly = "+" + digitsOnly;
                }

                var parsedNumber = phoneUtil.Parse(digitsOnly, null);
                int countryCode = parsedNumber.CountryCode;

                return $"+{countryCode}";
            }
            catch (NumberParseException)
            {
                throw new RequestException("شماره وارد شده معتبر نمی باشد");
            }
        }



        public static string createPassword(int length)
        {
            const string valid = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
            StringBuilder res = new StringBuilder();
            Random rnd = new Random();
            while (0 < length--)
            {
                res.Append(valid[rnd.Next(valid.Length)]);
            }
            return res.ToString();
        }

        public static string ToEnglishNumbers(this string input)
        {
            if (string.IsNullOrWhiteSpace(input))
                return input;

            var numberMap = new Dictionary<char, char>
            {
                ['۰'] = '0',
                ['۱'] = '1',
                ['۲'] = '2',
                ['۳'] = '3',
                ['۴'] = '4',
                ['۵'] = '5',
                ['۶'] = '6',
                ['۷'] = '7',
                ['۸'] = '8',
                ['۹'] = '9'
            };

            var result = new char[input.Length];
            for (int i = 0; i < input.Length; i++)
            {
                var ch = input[i];
                result[i] = numberMap.ContainsKey(ch) ? numberMap[ch] : ch;
            }

            return new string(result);
        }

        public static string ToPersianNumbers(this string input)
        {
            if (string.IsNullOrWhiteSpace(input))
                return input;

            var numberMap = new Dictionary<char, char>
            {
                ['0'] = '۰',
                ['1'] = '۱',
                ['2'] = '۲',
                ['3'] = '۳',
                ['4'] = '۴',
                ['5'] = '۵',
                ['6'] = '۶',
                ['7'] = '۷',
                ['8'] = '۸',
                ['9'] = '۹'
            };

            var result = new char[input.Length];
            for (int i = 0; i < input.Length; i++)
            {
                var ch = input[i];
                result[i] = numberMap.ContainsKey(ch) ? numberMap[ch] : ch;
            }

            return new string(result);
        }


        public static string moneyFormat(this string price)
        {
            if (price == null || price == "")
            {
                return null;
            }
            if (price.Contains("/"))
            {
                price = price.Split("/")[0];
            }
            if (price.Contains("."))
            {
                price = price.Split(".")[0];
            }
            var priceLong = Convert.ToInt64(price);
            return Int64.Parse(priceLong.ToString().Replace(",", "")).ToString("#,0").ToString();
        }
        public static string moneyFormat(this decimal price)
        {
            var priceLong = Convert.ToInt64(price);
            return Int64.Parse(priceLong.ToString().Replace(",", "")).ToString("#,0").ToString();
        }
        public static string moneyFormat(this decimal? price)
        {
            if (price == null)
            {
                return null;
            }
            var priceLong = Convert.ToInt64(price);
            return Int64.Parse(priceLong.ToString().Replace(",", "")).ToString("#,0").ToString();
        }
        public static string moneyFormat(this double? price)
        {
            if (price == null)
            {
                return null;
            }
            return Int64.Parse(price.Value.ToString().Replace(",", "")).ToString("#,0").ToString();
        }
        public static string moneyFormat(this double price)
        {

            return Int64.Parse(price.ToString().Replace(",", "")).ToString("#,0");
        }
        public static string moneyFormat(this long price)
        {

            return Int64.Parse(price.ToString().Replace(",", "")).ToString("#,0");
        }

        public static long toRial(this decimal price)
        {
            return Convert.ToInt64(price) * 10;
        }
        public static long toRial(this decimal? price)
        {
            return Convert.ToInt64(price.Value) * 10;
        }
        public static decimal cleanPrice(this string price)
        {
            if (price.Contains("."))
                return Convert.ToDecimal(price.Split(".")[0]);

            return Convert.ToDecimal(price);
        }

        public static string ToCardFormat(this string cardNumber)
        {
            if (string.IsNullOrWhiteSpace(cardNumber))
                return string.Empty;

            cardNumber = cardNumber.Replace(" ", "").Replace("-", "");

            if (cardNumber.Length != 16)
                return cardNumber;

            return string.Join(" ", Enumerable.Range(0, 4)
                .Select(i => cardNumber.Substring(i * 4, 4)));
        }
    }
}
