﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Text;

namespace Farakonesh.Shared.Helpers
{
    public static class DateTimeHelper
    {

        public static DateTime GetLocalTime(string timeZoneId = null, TimeSpan? add = null)
        {
            DateTime utc = DateTime.UtcNow;

            try
            {
                TimeZoneInfo tz = string.IsNullOrWhiteSpace(timeZoneId)
                    ? TimeZoneInfo.Local
                    : TimeZoneInfo.FindSystemTimeZoneById(timeZoneId);

                DateTime localTime = TimeZoneInfo.ConvertTimeFromUtc(utc, tz);

                return add.HasValue ? localTime.Add(add.Value) : localTime;
            }
            catch (TimeZoneNotFoundException)
            {
                var fallback = TimeZoneInfo.ConvertTimeFromUtc(utc, TimeZoneInfo.Local);
                return add.HasValue ? fallback.Add(add.Value) : fallback;
            }
            catch (InvalidTimeZoneException)
            {
                var fallback = TimeZoneInfo.ConvertTimeFromUtc(utc, TimeZoneInfo.Local);
                return add.HasValue ? fallback.Add(add.Value) : fallback;
            }
        }

        public static string resetFormatDateTimeToFourteenCharacter(this DateTime? date)
        {
            if (date == null)
            {
                return null;
            }
            string month = "";
            string day = "";
            string hour = "";
            string minute = "";
            string second = "";
            if (date.Value.Month.ToString().Length == 1)
            {
                month = "0" + date.Value.Month.ToString();
            }
            else
            {
                month = date.Value.Month.ToString();
            }

            if (date.Value.Day.ToString().Length == 1)
            {
                day = "0" + date.Value.Day.ToString();
            }
            else
            {
                day = date.Value.Day.ToString();
            }

            if (date.Value.Hour.ToString().Length == 1)
            {
                hour = "0" + date.Value.Hour.ToString();
            }
            else
            {
                hour = date.Value.Hour.ToString();
            }

            if (date.Value.Minute.ToString().Length == 1)
            {
                minute = "0" + date.Value.Minute.ToString();
            }
            else
            {
                minute = date.Value.Minute.ToString();
            }

            if (date.Value.Second.ToString().Length == 1)
            {
                second = "0" + date.Value.Second.ToString();
            }
            else
            {
                second = date.Value.Second.ToString();
            }

            var newFormatDate = date.Value.Year + "-" + month + "-" + day + "T" + hour + ":" + minute + ":" + second+"Z";

            return newFormatDate.ToString();
        }
        public static int convertDayToMonth(this int? numberDay)
        {
            if (numberDay == null)
            {
                return 0;
            }
            int numy, day = 0, month = 0, ext;
            numy = numberDay.Value;
            if (numy <= 31)
            {
                month = 1; day = numy;
            }
            if (numy > 31 && numy <= 186)
            {
                month = (numy / 31) + 1; day = numy % 31;
                if (day == 0)
                {
                    month--; day = 31;
                }
            }
            if (numy > 186 && numy <= 365)
            {
                ext = numy - 186;
                if (ext <= 30)
                {
                    month = 7; day = ext;
                }
                if (ext > 30)
                {
                    month = (ext / 30) + 7; day = ext % 30;
                    if (day == 0)
                    {
                        month--; day = 30;
                    }
                }
            }

            return month;
        }

        public static string getShamsiDate(this DateTime? milady)
        {
            if (milady == null)
                return null;
            PersianCalendar pc = new PersianCalendar();

            var rst = string.Format
                    (
                        "{0}/{1}/{2}",
                        pc.GetYear(milady.Value),
                        pc.GetMonth(milady.Value).ToString().PadLeft(2, '0'),
                        pc.GetDayOfMonth(milady.Value).ToString().PadLeft(2, '0')
                    );

            return (rst);
        }

        public static string getShamsiDate(this DateTime milady)
        {
            PersianCalendar pc = new PersianCalendar();

            var rst = string.Format
                    (
                        "{0}/{1}/{2}",
                        pc.GetYear(milady),
                        pc.GetMonth(milady).ToString().PadLeft(2, '0'),
                        pc.GetDayOfMonth(milady).ToString().PadLeft(2, '0')
                    );

            return (rst);
        }

        public static long? getShamsiWithoutSlash(this DateTime milady)
        {
            PersianCalendar pc = new PersianCalendar();
            var month = pc.GetMonth(milady).ToString().Length == 1 ? "0" + pc.GetMonth(milady).ToString() : pc.GetMonth(milady).ToString();
            var day = pc.GetDayOfMonth(milady).ToString().Length == 1 ? "0" + pc.GetDayOfMonth(milady).ToString() : pc.GetDayOfMonth(milady).ToString();
            var result = pc.GetYear(milady).ToString() + month + day;
            return Convert.ToInt64(result);
        }

        public static DateTime unixTimestampToDateTime(this long unixTimeStamp)
        {
            try
            {
                return new DateTime(1970, 1, 1, 0, 0, 0).AddSeconds(unixTimeStamp);
            }
            catch (Exception)
            {
                return DateTime.MaxValue;
            }
        }

        public static long dateTimeToUnixTimestamp(this DateTime idateTime)
        {
            try
            {
                idateTime = new DateTime(idateTime.Year, idateTime.Month, idateTime.Day, idateTime.Hour, idateTime.Minute, idateTime.Second);
                return long.Parse((idateTime - new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Local).ToLocalTime()).TotalSeconds.ToString(CultureInfo.InvariantCulture));
            }
            catch (Exception)
            {
                return 0L;
            }
        }
    }
}
