﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Mail;
using System.Net.Sockets;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using DnsClient;

namespace Farakonesh.Shared.Helpers
{
    public static class EmailValidatorHelper
    {
        private static readonly HashSet<string> DisposableDomains = new HashSet<string>(StringComparer.OrdinalIgnoreCase)
{
    "mailinator.com", "tempmail.com", "10minutemail.com", "guerrillamail.com", "yopmail.com",
    "throwawaymail.com", "trashmail.com", "getnada.com", "maildrop.cc", "dispostable.com",
    "fakeinbox.com", "mailcatch.com", "spamgourmet.com", "moakt.com", "guerrillamail.net",
    "temp-mail.org", "mailnesia.com", "mailnull.com", "disposablemail.com", "mytemp.email",
    "emailtemporanea.com", "temp-mail.io", "mail-temp.com", "tempinbox.com", "temp-mail.net",
    "spam4.me", "mail-temporaire.com", "mintemail.com", "tempail.com", "temp-mail.fr",
    "10minutemail.net", "temp-mail.ru", "trashmail.net", "tempemail.co", "emailondeck.com",
    "getairmail.com", "instant-mail.de", "spamavert.com", "tempmail.de", "mail-temporaire.fr",
    "dropmail.me", "fakemail.net", "guerrillamail.biz", "mailtothis.com", "temp-mail.org.uk",
    "tempmail.net", "maildrop.cc", "temp-mail.com", "trashmail.com", "spam4.me",
    "sharklasers.com", "spambog.com", "spamcowboy.com", "yopmail.net", "fakeinbox.xyz",
    "tempr.email", "dispostable.com"
};


        /// <summary>
        /// بررسی کامل ایمیل (ساختار، MX، و دامین موقت)
        /// </summary>
        public static bool IsValidEmail(this string email)
        {
            if (!IsValidEmailFormat(email))
                return false;

            string domain = email.Split('@')[1];

            if (IsDisposableDomain(domain))
                return false;

            if (!DomainHasMxRecord(domain))
                return false;

            return true;
        }

        /// <summary>
        /// اعتبارسنجی ساختار ایمیل
        /// </summary>
        private static bool IsValidEmailFormat(string email)
        {
            try
            {
                var addr = new MailAddress(email);
                return addr.Address == email;
            }
            catch
            {
                return false;
            }
        }

        /// <summary>
        /// چک کردن دامین‌های فیک یا موقتی
        /// </summary>
        private static bool IsDisposableDomain(string domain)
        {
            return DisposableDomains.Contains(domain);
        }

        /// <summary>
        /// بررسی اینکه دامین ایمیل دارای MX Record معتبر هست یا نه
        /// </summary>
        private static bool DomainHasMxRecord(string domain)
        {
            try
            {
                var lookup = new LookupClient();
                var result = lookup.Query(domain, QueryType.MX);
                return result.Answers.MxRecords().Count() > 0;
            }
            catch
            {
                return false;
            }
        }
    }
}
