﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Shared.Helpers
{
    public static class EnumHelper
    {
        public static string GetDescription(this Enum value)
        {
            if (value == null)
                return string.Empty;

            FieldInfo field = value.GetType().GetField(value.ToString());

            DisplayAttribute attribute = field?.GetCustomAttribute<DisplayAttribute>();
            return attribute?.GetDescription() ?? value.ToString();
        }
        public static bool HasFlag(this Enum value, Enum flag)
        {
            return value.HasFlag(flag);
        }

        public static List<KeyValuePair<int, string>> ToList<T>() where T : Enum
        {
            return Enum.GetValues(typeof(T))
                       .Cast<T>()
                       .Select(e => new KeyValuePair<int, string>(Convert.ToInt32(e), e.GetDescription()))
                       .ToList();
        }
    }
}
