﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Net.Sockets;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using Farakonesh.Shared.Exceptions;

namespace Farakonesh.Shared.Helpers
{
    public interface IPublicIpProvider
    {
        Task<IPAddress> GetPublicIpAsync();
    }

    public class IpifyPublicIpProvider : IPublicIpProvider
    {
        public async Task<IPAddress> GetPublicIpAsync()
        {
            using var httpClient = new HttpClient();
            var publicIpStr = await httpClient.GetStringAsync("https://api.ipify.org");
            return IPAddress.Parse(publicIpStr.Trim());
        }
    }
    public static class IpCheckHelper
    {


        /// <summary>
        /// smaple for get localRequestIp : var localIp = HttpContext.Connection.LocalIpAddress;
        /// </summary>
        /// <param name="targetIp"></param>
        /// <param name="localRequestIp"></param>
        /// <returns></returns>
        public static async Task<bool> IsExternalServerAsync(
              string targetIp,
              IPublicIpProvider publicIpProvider,
              IPAddress localRequestIp = null)
        {
            if (!IPAddress.TryParse(targetIp, out var inputIp))
                throw new RequestException("آی پی سرور میزبان نامعتبر می‌باشد");

            var hostName = Dns.GetHostName();
            var hostIps = Dns.GetHostAddresses(hostName)
                             .Where(ip => ip.AddressFamily == AddressFamily.InterNetwork)
                             .ToArray();

            if (hostIps.Contains(inputIp))
                return true;

            if (localRequestIp != null && localRequestIp.Equals(inputIp))
                return true;

            try
            {
                var publicIp = await publicIpProvider.GetPublicIpAsync();
                return publicIp.Equals(inputIp);
            }
            catch
            {
                return false;
            }
        }
    }
}
