﻿using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Shared.Helpers
{
    public static class LandLineValidatorHelper
    {
        public static Task IsValidIranianLandline(this string phoneNumber, string areaCodes)
        {

            if (string.IsNullOrWhiteSpace(phoneNumber))
                throw new RequestException("شماره ثابت ارسال شده معتبر نمی باشد");

            phoneNumber = phoneNumber.Trim().Replace(" ", "").Replace("-", "");


            if (!phoneNumber.StartsWith("0") || !phoneNumber.All(char.IsDigit))
                throw new RequestException("شماره ثابت ارسال شده معتبر نمی باشد");

            var validAreaCodes = areaCodes.Split(',', StringSplitOptions.RemoveEmptyEntries).Select(code => code.Trim()).ToHashSet();


            foreach (var areaCode in validAreaCodes)
            {
                if (phoneNumber.StartsWith(areaCode))
                {
                    var remainingLength = phoneNumber.Length - areaCode.Length;
                    if (remainingLength >= 7 && remainingLength <= 8)
                        return Task.CompletedTask;
                }
            }

            throw new RequestException("شماره ثابت ارسال شده معتبر نمی باشد");
        }

    }
}
