﻿using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Globalization;
using System.Text;
using System.Text.RegularExpressions;

namespace Farakonesh.Shared.Validations
{
    [AttributeUsage(AttributeTargets.Property | AttributeTargets.Field | AttributeTargets.Parameter,
    AllowMultiple = false)]
    public class RequiredFieldTextAttribute : ValidationAttribute
    {
        public string sepcialName { get; private set; }
        public RequiredFieldTextAttribute(string sepcialName)
        {
            this.sepcialName = sepcialName;
        }
        public override bool IsValid(object? value)
        {
            if (value is null)
            {
                throw new RequiredFieldException(string.Format(CultureInfo.CurrentCulture,
                $"خطای اعتبار سنجی: لطفا {this.sepcialName} را وارد نمایید"));
            }
            return true;
        }

        public override string FormatErrorMessage(string name)
        {
            return string.Format(CultureInfo.CurrentCulture,
                $"خطای اعتبار سنجی: لطفا {this.sepcialName} را وارد نمایید");
        }

    }
}
