﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Text.Json;
using System.Threading.Tasks;

namespace Farakonesh.Shared.Validations
{
    [AttributeUsage(AttributeTargets.Property | AttributeTargets.Field | AttributeTargets.Parameter, AllowMultiple = false)]
    public class RequiredJsonFieldAttribute : ValidationAttribute
    {
        public string DisplayName { get; }

        public RequiredJsonFieldAttribute(string displayName)
        {
            DisplayName = displayName;
        }

        public override bool IsValid(object? value)
        {

            if (value is null || string.IsNullOrWhiteSpace(value.ToString()))
            {
                throw new ValidationException(GetErrorMessage());
            }

    
            try
            {
                JsonDocument.Parse(value.ToString()!);
            }
            catch (JsonException)
            {
                throw new ValidationException($"{DisplayName} باید یک رشته JSON معتبر باشد.");
            }

            return true;
        }

        public override string FormatErrorMessage(string name)
        {
            return GetErrorMessage();
        }

        private string GetErrorMessage()
        {
            return $"خطای اعتبارسنجی: لطفا {DisplayName} را به صورت یک JSON معتبر وارد نمایید.";
        }
    }
    }
