﻿using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Shared.Validations
{
    [AttributeUsage(AttributeTargets.Property | AttributeTargets.Field | AttributeTargets.Parameter, AllowMultiple = false)]
    public class RequiredPositiveNumberAttribute : ValidationAttribute
    {
        public string SpecialName { get; private set; }

        public RequiredPositiveNumberAttribute(string specialName)
        {
            SpecialName = specialName;
        }

        public override bool IsValid(object value)
        {
            if (value is null)
            {
                throw new RequiredFieldException(
                    $"خطای اعتبارسنجی: لطفا {SpecialName} را وارد نمایید");
            }

            if (decimal.TryParse(value.ToString(), out decimal number))
            {
                if (number <= 0)
                {
                    throw new RequiredFieldException(
                        $"خطای اعتبارسنجی: {SpecialName} باید بزرگتر از صفر باشد");
                }
            }
            else
            {
                throw new RequiredFieldException(
                    $"خطای اعتبارسنجی: {SpecialName} نامعتبر است");
            }

            return true;
        }

        public override string FormatErrorMessage(string name)
        {
            return $"خطای اعتبارسنجی: مقدار {SpecialName} باید بزرگتر از صفر باشد";
        }
    }
}
