﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Shared.Validations
{
    public class SafeUrlAttribute : ValidationAttribute
    {
        private static readonly string[] AllowedSchemes = new[] { "http", "https", "mailto", "tel" };

        public override bool IsValid(object value)
        {
            var url = value?.ToString()?.Trim();
            if (string.IsNullOrWhiteSpace(url)) return true;

            if (!Uri.TryCreate(url, UriKind.Absolute, out var uri))
                return false;

            return AllowedSchemes.Contains(uri.Scheme.ToLowerInvariant());
        }
    }
}
