﻿using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Globalization;
using System.Text;

namespace Farakonesh.Shared.Validations
{
    [AttributeUsage(AttributeTargets.Property | AttributeTargets.Field | AttributeTargets.Parameter,
AllowMultiple = false)]
    public class ValidateGuidAttribute: ValidationAttribute
    {
        public string sepcialName { get; private set; }
        public ValidateGuidAttribute(string sepcialName)
        {
            this.sepcialName = sepcialName;
        }
        public override bool IsValid(object value)
        {
            var input = Convert.ToString(value, CultureInfo.CurrentCulture);
            if (value is null)
            {
                throw new RequiredFieldException(string.Format(CultureInfo.CurrentCulture,
                $"خطای اعتبار سنجی: لطفا {this.sepcialName} را وارد نمایید"));
            }

            if (string.IsNullOrWhiteSpace(input))
            {
                throw new RequiredFieldException(string.Format(CultureInfo.CurrentCulture,
                $"خطای اعتبار سنجی: لطفا {this.sepcialName} را صحیح وارد نمایید"));
            }

            Guid guid;
            if (!Guid.TryParse(input, out guid))
            {
                throw new RequiredFieldException(string.Format(CultureInfo.CurrentCulture,
                 $"خطای اعتبار سنجی: ساختار کلید یکتای {this.sepcialName} را صحیح ارسال نمائید"));
            }
            return true;
        }

        public override string FormatErrorMessage(string name)
        {
            return string.Format(CultureInfo.CurrentCulture,
                $"خطای اعتبار سنجی: لطفا {this.sepcialName} را وارد نمایید");
        }
 
    }
}
