﻿using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Text.Json;
using System.Threading.Tasks;

namespace Farakonesh.Shared.Validations
{
    [AttributeUsage(AttributeTargets.Property | AttributeTargets.Field | AttributeTargets.Parameter,
       AllowMultiple = false)]
    public class ValidateJsonAttribute : ValidationAttribute
    {
        public string SpecialName { get; private set; }

        public ValidateJsonAttribute(string specialName)
        {
            SpecialName = specialName;
        }

        public override bool IsValid(object value)
        {
            var input = Convert.ToString(value, CultureInfo.CurrentCulture);

            if (value is null)
            {
                throw new RequiredFieldException(
                    $"خطای اعتبار سنجی: لطفا {SpecialName} را وارد نمایید"
                );
            }

            if (string.IsNullOrWhiteSpace(input))
            {
                throw new RequiredFieldException(
                    $"خطای اعتبار سنجی: لطفا {SpecialName} را صحیح وارد نمایید"
                );
            }

            try
            {
                JsonDocument.Parse(input);
            }
            catch (Exception)
            {
                throw new RequiredFieldException(
                    $"خطای اعتبار سنجی: ساختار JSON مربوط به {SpecialName} صحیح نمی‌باشد"
                );
            }

            return true;
        }

        public override string FormatErrorMessage(string name)
        {
            return $"خطای اعتبار سنجی: لطفا {SpecialName} را وارد نمایید";
        }
    }
}
