﻿using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Globalization;
using System.Text;

namespace Farakonesh.Shared.Validations
{
    [AttributeUsage(AttributeTargets.Property | AttributeTargets.Field | AttributeTargets.Parameter,
   AllowMultiple = false)]
    public class ValidateNationalCodeAttribute : ValidationAttribute
    {
        public string sepcialName { get; private set; }
        public ValidateNationalCodeAttribute(string sepcialName)
        {
            this.sepcialName = sepcialName;
        }
        public override bool IsValid(object value)
        {
            if (value is null)
            {
                throw new RequiredFieldException(string.Format(CultureInfo.CurrentCulture,
                $"خطای اعتبار سنجی: لطفا {this.sepcialName} را وارد نمایید"));
            }
            var check = checkNationalCode(value.ToString());
            if(check)
            {
                return true;
            }
            else
            {
                throw new RequiredFieldException(string.Format(CultureInfo.CurrentCulture,
              $"خطای اعتبار سنجی: لطفا {this.sepcialName} را صحیح وارد نمایید"));
            }
        }

        public override string FormatErrorMessage(string name)
        {
            return string.Format(CultureInfo.CurrentCulture,
                $"خطای اعتبار سنجی: لطفا {this.sepcialName} را وارد نمایید");
        }
        private bool checkNationalCode(string value)
        {
            if(string.IsNullOrWhiteSpace(value))
            {
                return false;
            }
            char[] chArray = value.ToCharArray();
            int[] numArray = new int[chArray.Length];
            for (int i = 0; i < chArray.Length; i++)
            {
                numArray[i] = (int)char.GetNumericValue(chArray[i]);
            }
            int num2 = numArray[9];
            switch (value)
            {
                case "0000000000":
                case "1111111111":
                case "22222222222":
                case "33333333333":
                case "4444444444":
                case "5555555555":
                case "6666666666":
                case "7777777777":
                case "8888888888":
                case "9999999999":
                    return false;
            }
            int num3 = ((((((((numArray[0] * 10) + (numArray[1] * 9)) + (numArray[2] * 8)) + (numArray[3] * 7)) + (numArray[4] * 6)) + (numArray[5] * 5)) + (numArray[6] * 4)) + (numArray[7] * 3)) + (numArray[8] * 2);
            int num4 = num3 - ((num3 / 11) * 11);
            if ((((num4 == 0) && (num2 == num4)) || ((num4 == 1) && (num2 == 1))) || ((num4 > 1) && (num2 == Math.Abs((int)(num4 - 11)))))
            {
                return true;
            }
            else
            {
                return false;
            }
        }
    }
}
